<!--
  Assumes that all preformatted sections should declare the language they use
-->
<sch:pattern id="preformat_lang" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <sch:rule context="preformat[@role='lang-xml']">

    <sch:assert test="not(starts-with(., '&lt;'))"
                id="pre_xml_start"
                properties="fragment" flag="warning"
    >The XML content should always start with &#x201C;&lt;&#x201D;</sch:assert>

    <sch:assert test="not(matches(replace(., '\s*\n+(\s\s)*&lt;', '&lt;'), '[^\.]\s&lt;'))"
                id="pre_xml_indent"
                properties="fragment" flag="warning"
    >The XML content is not indented correctly (use 2 spaces for indentation)</sch:assert>

  </sch:rule>

  <sch:rule context="preformat">

    <sch:assert test="@role"
                id="pre_no_lang"
                properties="fragment" flag="warning"
    >Preformatted content must specify language using role e.g. `lang-xml` or use `text`</sch:assert>

  </sch:rule>

</sch:pattern>