<!--
  A pattern is a set of rules giving constraints that are in some way related.

  @id = The `id` attribute provides a unique name for the pattern (optional).

  <sch:title> = A summary of the purpose of pattern for documentation (optional)
-->
<sch:pattern xmlns:sch="http://purl.oclc.org/dsdl/schematron">
  <sch:title><!-- ENTER TITLE HERE --></sch:title>

  <!--
    A rule is a list of assertions tested within the context specified by the
    required `context` attribute.

    A rule must contain at least one `sch:assert` or `sch:report` element that
    can be entered in any order.

    It is not an error if a rule never fires in a document. In order to test
    that a document always has some context, a new pattern should be created
    from the context of the document, with an assertion requiring the element
    or attribute.

    @context = Specifies the rule context expression (XPath pattern)
               For example, to apply a set of assertions to a list or table,
               set the context to `list` or `table`.

    <sch:assert> = An assertion made about the context that returns an error
                   when it evaluates to false
    <sch:report> = An assertion made about the context that returns a message
                   when it evaluates to true
  -->
  <sch:rule context="[ENTER CONTEXT HERE]">

    <!--
       An assertion made about the context nodes.

       The optional `diagnostics` attribute is a reference to further
       diagnostic information.

       The optional `properties` attribute is a reference to further
       diagnostic information.

       The `flag` attribute allows more detailed outcomes. A Boolean variable
       with initial value false. A flag is implicitly declared by an assertion
       or rule having a flag attribute with that name. The value of a flag
       becomes true when an assertion with that flag fails or a rule with that
       flag fires. The purpose of flags is to convey state or severity
       information to a subsequent process.

       The data content is a natural-language assertion. It should be a
       positive statement of a constraint and may contain information about
       actual values in addition to expected values and may contain diagnostic
       information.

       @test = attribute is an assertion test evaluated in the current context.
               If the test evaluates negative, the assertion fails and an error
               is reported (required).

       @diagnostics = a reference to a diagnostic (defined in <diagnostics>)
       @properties  = a reference to a property information (defined in
                      <properties>). PageSeeder support the `fragment` property
                      to direct the user to fragment in the user interface

       <sch:span>     = A portion of text that should be rendered in a distinct
                        way, keyed with the class attribute.
       <sch:emph>     = A portion of text that should be rendered with some
                        emphasis.
       <sch:value-of> = Finds or calculates values from the document. The
                        required select attribute is an expression evaluated in
                        the current context.
     -->
    <sch:assert test="[ENTER TEST]" properties="fragment"
    ><!-- ENTER TEXT FOR USER --></sch:assert>

    <!--
      An assertion made about the context nodes. If the test evaluates positive
      the report succeeds and the natural language content below is displayed
      to the user.

      It is identical to `sch:assert` in all other aspects
     -->
    <sch:report test="[ENTER TEST]" properties="fragment"
    ><!-- ENTER TEXT FOR USER --></sch:report>

  </sch:rule>

</sch:pattern>