<?xml version="1.0"?>
<!--
  ~ Copyright (c) 1999-2023. Allette Systems Pty Ltd
  -->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron">
  <sch:title>Rules for default documents</sch:title>

  <sch:let name="definitions" value="document('ps:search?filters=psdocumenttype:definition&amp;pagesize=2000')" />

  <!--
    Set of rules applying to inline labels
  -->
  <sch:pattern>
    <sch:title>Inline label</sch:title>

    <sch:rule context="inline[@label='definition']">

      <sch:let name="lc"
               value="lower-case(.)" />

      <sch:let name="lc-singular"
               value="if (ends-with(.,'s'))
                      then lower-case(substring(., 1, string-length(.)-1))
                      else lower-case(.)" />

      <sch:let name="matches"
               value="count($definitions//field[
                        (@name='pstitle' and (lower-case(.)=$lc or lower-case(.)=$lc-singular)) or
                        (@name='psproperty-synonym' and (lower-case(.)=$lc or lower-case(.)=$lc-singular))])" />

      <!-- Definitions must exist -->
      <sch:assert id="DEFINITION_MISSING" test="$matches gt 0"
                  diagnostics="fragment">
        The definition for "<sch:value-of select="."/>" does not exist.
      </sch:assert>

      <!-- Terms must only match one definition -->
      <sch:assert id="MULTIPLE_DEFINITION" test="$matches lt 2"
                  diagnostics="fragment">
        There are multiple definitions for "<sch:value-of select="."/>".
      </sch:assert>

    </sch:rule>

  </sch:pattern>

  <sch:diagnostics>

    <sch:diagnostic id="fragment"><sch:value-of select="ancestor-or-self::fragment/@id"/></sch:diagnostic>

  </sch:diagnostics>

</sch:schema>