Shared glossary bundle
======================================

To use this bundle follow these steps:

1. Install the bundle under the root document type for your publication (e.g. `references`).
2. **Set the publication type on your publication root document to `report`.**
3. Edit the `Export publication as custom DOCX` description in the `document-config.xml` to make it more specific.
5. To create user help, while previewing this document copy the headings/text below to your clip-board.
   Create a group named `help` under your project and create a document of type `help` in that group
   with title `Shared glossary`. Edit this document and paste your clip-board content
   into the bottom fragment and in the keypoint block type `Special features of this publication`.
   In the **Document info** panel **Metadata** type the publication root document type (e.g. `references`),
   Press **Enter** and click **Save**. Now the content below will display to users when they click the **(?) help** icon.

Inserting a glossary
--------------------

Linking terms to their definition in a glossary can be done using xrefs but if there are a large volume of definitions
the xrefs might make the server and user interface slow. That's why this project uses 'weak linking' instead of xrefs,
which means that a definition inline label is applied to a term which then matches with
a corresponding definition document in the group that has the term as its title.
There is no actual link between the two, but an implied link which we call 'weak linking'.
It is much easier to add weak links and faster to process or display documents containing them.

1. Go to your publication root document and click the edit icon pencil (top right) to enter edit mode.
2. Click the **Browse** button at the bottom and then the **browse** icon at the top.
3. Select Glossary under **Document type**, enter a Document title and click **Create**.
4. Click on **Select this document**, click **Save** and then Press **Ctrl-S**.
5. Navigate to a word in the paragraph you want to be a term and select it. 
6. Click on the Inline label (highlighter) icon at the top and select **Inline label definition**. 
7. Press **Ctrl-S** to save. 
8. Click the **(tick) Document validation** icon in the right margin and the following message should appear
   *“The definition for `[your term]` does not exist”*. 
9. Click the **(folder) Group documents** icon at the top and then on **(+) > Create document**. 
10. Select Definition under **Document type**, type your term as the Document title and click **Create**. 
11. Click **Open document** and double click the empty fragment under Synonym to edit it. 
12. Enter a definition for your term. 
13. Click next to **Synonym** and type another term which should match this definition
    (for example if your term was subsystem you could type sub-system). Then press **Enter**. 
14. Press **Ctrl-S** to save. 
15. Go back to the original document. You can use the **RECENTLY VIEWED** list
    in the navigation drop down menu (top left). 
16. Click on the Document validation (tick) icon in the right margin and the message
    *“No reports or errors” should appear because your term has now been defined.* 
17. Click on the glossary document you created in the Table of contents (left). 
18. This document contains a marker section titled “Definitions - will be inserted here”. 
    When the publication is exported to Word the full definitions will be inserted here
    and the terms will be linked to them. 
19. Add a term as in step 6 in this section by clicking **(+) insert fragment**
    so its definition will be included even though it doesn't appear in the publication content
    (for example it may appear in another definition). Use this method to include any extra definitions you would like. 
21. Click on the root document at the top of the Table of contents (left). 
22. Click on the **(tick) Document validation** icon in the right margin. 
23. Select **definition list** from the Available schemas drop down menu and click **Validate**. 
24. For your information this will list all the terms currently used in the publication.


