<?xml version="1.0"?>
<!--
  This schematron checks the word export config for a publication
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:title>Check publication word export config</sch:title>

  <sch:pattern>

    <sch:let name="pubs" value="document('ps:publications')" />
  
    <sch:let name="config" value="document(concat('ps:resource?location=publication/',
                                  $pubs//publication[1]/@type,'/word-export-config.xml'))" />
  
    <sch:rule context="block">
        
      <sch:assert test="$config//block/label/@value=current()/@label"
                  id="block_unmapped" flag="warning" properties="fragment remove-block-label"
      >The block label "<sch:value-of select="@label"/>" isn't mapped to a DOCX word style.</sch:assert>
  
    </sch:rule>

  </sch:pattern>

  <sch:properties xmlns:sch="http://purl.oclc.org/dsdl/schematron">
  
    <!-- Allows PageSeeder to identify the fragment and show in interface -->
    <sch:property id="fragment" ><sch:value-of select="ancestor-or-self::fragment/@id"/></sch:property>
  
    <!-- Quick fix -->
    <sch:property id="remove-block-label" role="quickfix">
      <description>Remove the block label: <sch:value-of select="@label"/></description>
      <parameter name="label"><sch:value-of select="@label"/></parameter>
    </sch:property>
    
  </sch:properties>
  
</sch:schema>