<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<!--
  List of URL configs
-->
<xsl:template match="root[@service='api-urls-configs']" mode="json">
  <json:array>
    <xsl:apply-templates select="//url-type" mode="json" />
  </json:array>
</xsl:template>

<xsl:template match="url-type" mode="json">
  <xsl:variable name="creation" select="url-config/creation"/>
  <json:map>
    <json:string key="name"><xsl:value-of select="@name" /></json:string>
    <json:string key="title"><xsl:value-of select="if ($creation/@title) then $creation/@title else @name" /></json:string>
    <xsl:if test="$creation/domain">
      <json:array key="domains">
        <xsl:for-each select="$creation/domain">
          <json:string><xsl:value-of select="@name"/></json:string>
        </xsl:for-each>
      </json:array>
    </xsl:if>
    <xsl:if test="$creation/mediatype">
      <json:array key="mediatypes">
        <xsl:for-each select="$creation/mediatype">
          <json:string><xsl:value-of select="@name"/></json:string>
        </xsl:for-each>
      </json:array>
    </xsl:if>
    <xsl:apply-templates select="url-config/labeling" mode="json-config"/>
  </json:map>
</xsl:template>

</xsl:stylesheet>
