<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-document-toc']" mode="json">
  <json:map>
    <json:array key="publications">
      <xsl:apply-templates select="//publication" mode="json"/>
    </json:array>
    <xsl:apply-templates select="//toc/publication-tree" mode="json">
      <xsl:with-param name="key">tree</xsl:with-param>
    </xsl:apply-templates>
  </json:map>
</xsl:template>

<xsl:template match="root[@service='api-document-toc-items']" mode="json">
  <json:array>
    <xsl:apply-templates select="//result" mode="api-document-toc-items-json"/>
  </json:array>
</xsl:template>

<xsl:template match="root[@service='api-document-toc-numbering']" mode="json">
  <json:array>
    <xsl:apply-templates select="content//publication-tree//document-ref |
                                 content//publication-tree//heading-ref |
                                 content//publication-tree//para-ref" mode="api-document-toc-numbering-json" />
  </json:array>
</xsl:template>

<xsl:template match="result" mode="api-document-toc-items-json">
  <xsl:choose>
    <xsl:when test="field[@name='pstype'] = 'task'">
      <xsl:variable name="uriid" select="field[@name='pscontexturiid']"/>
      <json:map>
        <json:string key="is"><xsl:value-of select="field[@name='pssubtype']"/></json:string>
        <xsl:if test="$uriid">
          <json:number key="uriid"><xsl:value-of select="$uriid"/></json:number>
        </xsl:if>
        <json:string key="fragment"><xsl:value-of select="field[@name='pscontextfragment']"/></json:string>
        <json:string key="status"><xsl:value-of select="field[@name='psstatus']"/></json:string>
        <json:string key="priority"><xsl:value-of select="field[@name='pspriority']"/></json:string>
        <json:string key="title"><xsl:value-of select="field[@name='pstitle']"/></json:string>
        <json:array key="parents">
          <xsl:variable name="ref" select="//document-ref[@uriid = $uriid]"/>
          <xsl:for-each select="$ref/parent::part/ancestor::part">
            <xsl:variable name="part" select="." />
            <json:string>
              <xsl:apply-templates select="//publication-tree/part" mode="compute-tocid">
                <xsl:with-param name="target" select="generate-id($part)" tunnel="yes" />
                <xsl:with-param name="prefix" select="if (@uriid) then @uriid else ../@uriid" />
              </xsl:apply-templates>
            </json:string>
          </xsl:for-each>
        </json:array>
      </json:map>
    </xsl:when>
    <xsl:when test="field[@name='pstype'] = 'comment' and field[@name='pscomment-status'] = 'None'">
      <xsl:variable name="uriid" select="field[@name='pscontexturiid']"/>
      <json:map>
        <json:string key="is"><xsl:value-of select="field[@name='pstype']"/></json:string>
        <xsl:if test="$uriid">
          <json:number key="uriid"><xsl:value-of select="$uriid"/></json:number>
        </xsl:if>
        <json:string key="fragment"><xsl:value-of select="field[@name='pscontextfragment']"/></json:string>
        <json:string key="title"><xsl:value-of select="field[@name='pstitle']"/></json:string>
        <json:array key="parents">
          <xsl:variable name="ref" select="//document-ref[@uriid = $uriid]"/>
          <xsl:for-each select="$ref/parent::part/ancestor::part">
            <xsl:variable name="part" select="." />
            <json:string>
              <xsl:apply-templates select="//publication-tree/part" mode="compute-tocid">
                <xsl:with-param name="target" select="generate-id($part)" tunnel="yes" />
                <xsl:with-param name="prefix" select="if (@uriid) then @uriid else ../@uriid" />
              </xsl:apply-templates>
            </json:string>
          </xsl:for-each>
        </json:array>
      </json:map>
    </xsl:when>
  </xsl:choose>
</xsl:template>

<xsl:template match="part" mode="compute-tocid">
  <xsl:param name="prefix"/>
  <xsl:param name="target" tunnel="yes" />
  <xsl:variable name="id" select="if ($prefix) then concat($prefix, '-', position()) else position()"/>
  <xsl:choose>
    <xsl:when test="generate-id() = $target"><xsl:value-of select="$id" /></xsl:when>
    <xsl:otherwise>
      <xsl:variable name="sub-prefix" select="if (heading-ref) then $id else document-ref/@uriid"/>
      <xsl:apply-templates select="part" mode="compute-tocid">
        <xsl:with-param name="prefix" select="$sub-prefix"/>
      </xsl:apply-templates>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template match="document-ref" mode="api-document-toc-numbering-json">
  <json:map>
    <json:string key="type">document</json:string>
    <json:string key="title"><xsl:value-of select="if (normalize-space(@title)='') then 'no title' else @title" /></json:string>
    <json:string key="prefix"><xsl:value-of select="if (@numbered and not(@prefix)) then 'undefined' else @prefix" /></json:string>
    <json:string key="canonical"><xsl:value-of select="@canonical" /></json:string>
    <json:string key="pubLevel"><xsl:value-of select="../@level" /></json:string>
    <json:string key="sourceLevel"><xsl:value-of select="@level" /></json:string>
    <json:string key="numbering"><xsl:value-of select="@numbered" /></json:string>
    <json:string key="labels"><xsl:value-of select="@labels" /></json:string>
    <json:number key="uriid"><xsl:value-of select="@uriid" /></json:number>
    <json:boolean key="hasError"><xsl:value-of select="@numbered and not(@prefix)" /></json:boolean>
  </json:map>
</xsl:template>

<xsl:template match="heading-ref" mode="api-document-toc-numbering-json">
  <xsl:variable name="document" select="(ancestor::part[preceding-sibling::document-ref]/preceding-sibling::document-ref)[last()]" />
  <json:map>
    <json:string key="type">heading</json:string>
    <json:string key="title"><xsl:value-of select="if (normalize-space(@title)='') then 'no title' else @title" /></json:string>
    <json:string key="prefix"><xsl:value-of select="if (@numbered and not(@prefix)) then 'undefined' else @prefix" /></json:string>
    <json:string key="canonical"><xsl:value-of select="@canonical" /></json:string>
    <json:string key="pubLevel"><xsl:value-of select="../@level" /></json:string>
    <json:string key="sourceLevel"><xsl:value-of select="@level" /></json:string>
    <json:string key="numbering"><xsl:value-of select="@numbered" /></json:string>
    <json:number key="uriid"><xsl:value-of select="../@uriid" /></json:number>
    <json:string key="position"><xsl:value-of select="$document/@position" /></json:string>
    <json:string key="fragment"><xsl:value-of select="@fragment" /></json:string>
    <json:string key="index"><xsl:value-of select="@index" /></json:string>
    <xsl:if test="@level = '1' and parent::part/preceding-sibling::part[@uriid = $document/@uriid and heading-ref/@level='1']">
      <json:string key="warning">Not recommended to have a document with multiple heading 1</json:string>
    </xsl:if>
    <json:boolean key="hasError"><xsl:value-of select="@numbered and not(@prefix)" /></json:boolean>
  </json:map>
</xsl:template>

<xsl:template match="para-ref" mode="api-document-toc-numbering-json">
  <xsl:variable name="document" select="(preceding-sibling::document-ref|ancestor::part[preceding-sibling::document-ref]/preceding-sibling::document-ref)[last()]" />
  <xsl:variable name="uriid" select="if ($document) then $document/@uriid else ../@uriid" />
  <json:map>
    <json:string key="type">para</json:string>
    <json:string key="title"><xsl:value-of select="if (normalize-space(@title)='') then 'no title' else @title" /></json:string>
    <json:string key="prefix"><xsl:value-of select="if (@numbered and not(@prefix)) then 'undefined' else @prefix" /></json:string>
    <json:string key="canonical"><xsl:value-of select="@canonical" /></json:string>
    <json:string key="pubLevel"><xsl:value-of select="@part-level" /></json:string>
    <json:string key="sourceLevel"><xsl:value-of select="@level" /></json:string>
    <json:string key="numbering"><xsl:value-of select="@numbered" /></json:string>
    <json:string key="label"><xsl:value-of select="@block-label" /></json:string>
    <json:number key="uriid"><xsl:value-of select="$uriid" /></json:number>
    <json:string key="position"><xsl:value-of select="$document/@position" /></json:string>
    <json:string key="fragment"><xsl:value-of select="@fragment" /></json:string>
    <json:string key="index"><xsl:value-of select="@index" /></json:string>
    <json:boolean key="hasError"><xsl:value-of select="@numbered and not(@prefix)" /></json:boolean>
  </json:map>
</xsl:template>
</xsl:stylesheet>
