<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-document-fragment']" mode="json">
  <json:map>
    <xsl:apply-templates select="content/document-fragment|content/metadata" mode="api-document-fragment"/>
  </json:map>
</xsl:template>

<xsl:template match="document-fragment" mode="api-document-fragment">
  <xsl:if test="@draft">
    <json:boolean key="draft"><xsl:value-of select="@draft"/></json:boolean>
  </xsl:if>
  <xsl:apply-templates select="locator" mode="json-document">
    <xsl:with-param name="key" select="'locator'"/>
  </xsl:apply-templates>
  <xsl:apply-templates select="fragment|media-fragment|properties-fragment|xref-fragment" mode="json-document">
    <xsl:with-param name="key" select="'fragment'"/>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="metadata" mode="api-document-fragment">
  <xsl:apply-templates select="." mode="json-document">
    <xsl:with-param name="key" select="'fragment'"/>
  </xsl:apply-templates>
</xsl:template>

</xsl:stylesheet>
