<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='api-document-fragment-create' or @service='api-document-fragment-update']" mode="json">
  <xsl:variable name="document-fragment" select=".//document-fragment" />
  <json:map>
    <xsl:apply-templates select="$document-fragment/locator" mode="json-document">
      <xsl:with-param name="key" select="'locator'"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="$document-fragment/fragment|
                                 $document-fragment/media-fragment|
                                 $document-fragment/properties-fragment|
                                 $document-fragment/xref-fragment" mode="json-document">
      <xsl:with-param name="key" select="'fragment'"/>
    </xsl:apply-templates>
  </json:map>
</xsl:template>

</xsl:stylesheet>
