<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="3.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<!-- General logs -->
<xsl:template match="root[@service='api-admin-project-file'
                       or @service='api-admin-default-file']" mode="json">
  <json:map>
    <xsl:apply-templates select="content/file" mode="json-file"/>
  </json:map>
</xsl:template>

<!-- Recent logs -->
<xsl:template match="file" mode="json-file">
  <json:map key="file">
    <json:string key="name"><xsl:value-of select="@name"/></json:string>
    <json:string key="path"><xsl:value-of select="@path"/></json:string>
    <json:string key="type"><xsl:value-of select="@type"/></json:string>
    <json:string key="mediatype"><xsl:value-of select="@mediatype"/></json:string>
    <xsl:if test="@length">
      <json:number key="length"><xsl:value-of select="@length"/></json:number>
    </xsl:if>
    <json:string key="modified"><xsl:value-of select="@modified"/></json:string>
    <json:boolean key="text"><xsl:value-of select="@text = 'true'"/></json:boolean>
    <json:boolean key="editable"><xsl:value-of select="@editable = 'true'"/></json:boolean>
    <json:string key="content"><xsl:value-of select="f:_get-file-content(.)"/></json:string>
  </json:map>
</xsl:template>

<xsl:function name="f:_get-file-content" as="xs:string">
  <xsl:param name="file" as="element(file)"/>
  <xsl:value-of><xsl:apply-templates select="$file" mode="project-file-value"/></xsl:value-of>
</xsl:function>

<xsl:template match="file" mode="project-file-value">
  <xsl:variable name="psml-config" select="tokenize(@path, '/')[last()-1]"/>
  <xsl:choose>
    <!-- Existing files -->
    <xsl:when test="not(@status = 'not-found') and text()"><xsl:value-of select="text()"/></xsl:when>
    <!-- Files templates -->
    <xsl:when test="@name = 'document-config.xml'">
      <xsl:call-template name="new-file-psml-documentconfig"><xsl:with-param name="config" select="$psml-config"/></xsl:call-template>
    </xsl:when>
    <xsl:when test="@name = 'publication-config.xml'">
      <xsl:call-template name="new-file-publication-config" />
    </xsl:when>
    <xsl:when test="@name = 'xref-config.xml'">
      <xsl:call-template name="new-file-xrefconfig"/>
    </xsl:when>
    <xsl:when test="@name = 'media-template.psml'">
      <xsl:call-template name="new-file-psml-mediatemplate"><xsl:with-param name="config" select="$psml-config"/></xsl:call-template>
    </xsl:when>
    <xsl:when test="@name = 'document-template.psml'">
      <xsl:call-template name="new-file-psml-documenttemplate"><xsl:with-param name="config" select="$psml-config"/></xsl:call-template>
    </xsl:when>
    <xsl:when test="@name = 'url-template.psml'">
      <xsl:call-template name="new-file-psml-urltemplate"><xsl:with-param name="config" select="$psml-config"/></xsl:call-template>
    </xsl:when>
    <xsl:when test="@name = 'url-config.xml'">
      <xsl:call-template name="new-file-psml-urlconfig"><xsl:with-param name="config" select="$psml-config"/></xsl:call-template>
    </xsl:when>
    <xsl:when test="@name = 'publish-config.xml'">
      <xsl:call-template name="new-file-psml-publishconfig"/>
    </xsl:when>
    <xsl:when test="@name = 'schedule-config.xml'">
      <xsl:call-template name="new-file-psml-scheduleconfig"/>
    </xsl:when>
    <xsl:when test="@name = 'organization-config.xml'">
      <xsl:call-template name="new-file-organizationconfig"/>
    </xsl:when>
    <xsl:when test="@name = 'editor-config.xml' and contains(@path, '/url/')">
      <xsl:call-template name="new-file-editorconfig-url" />
    </xsl:when>
    <xsl:when test="@name = 'editor-config.xml'">
      <xsl:call-template name="new-file-editorconfig" />
    </xsl:when>
    <xsl:when test="@name = 'word-import-config.xml'">
      <xsl:call-template name="new-word-import-config" />
    </xsl:when>
    <xsl:when test="@name = 'psml-split-config.xml'">
      <xsl:call-template name="new-psml-split-config" />
    </xsl:when>
    <xsl:when test="@name = 'word-export-config.xml'">
      <xsl:call-template name="new-word-export-config" />
    </xsl:when>
    <xsl:when test="@name = 'pdf-export-config.xml'">
      <xsl:call-template name="new-pdf-export-config" />
    </xsl:when>
    <xsl:when test="@name = 'build.xml'">
      <xsl:call-template name="new-build-file" />
    </xsl:when>
    <xsl:when test="@mediatype = 'application/xslt+xml' and contains(@path, 'notification') and ends-with(@path, '-text.xsl')">
      <xsl:call-template name="new-file-xsl-email-text"/>
    </xsl:when>
    <xsl:when test="@mediatype = 'application/xslt+xml' and contains(@path, 'notification')">
      <xsl:call-template name="new-file-xsl-email"/>
    </xsl:when>
    <xsl:when test="@mediatype = 'application/xslt+xml'">
      <xsl:call-template name="new-file-xsl"/>
    </xsl:when>
    <xsl:when test="@mediatype = 'text/xml' and contains(@path, '/member/')">
      <xsl:call-template name="new-file-member-details"/>
    </xsl:when>
    <xsl:when test="@mediatype = 'application/schematron+xml' and ends-with(@path, '/schema/properties.sch')">
      <xsl:call-template name="new-file-properties-schematron"/>
    </xsl:when>
    <xsl:when test="@mediatype = 'application/schematron+xml' and contains(@path, '/document/')">
      <xsl:call-template name="new-file-psml-schematron-media"><xsl:with-param name="config" select="$psml-config"/></xsl:call-template>
    </xsl:when>
    <xsl:when test="@mediatype = 'application/schematron+xml' and contains(@path, '/url/')">
      <xsl:call-template name="new-file-psml-schematron-url"><xsl:with-param name="config" select="$psml-config"/></xsl:call-template>
    </xsl:when>
    <xsl:when test="@mediatype = 'application/schematron+xml'">
      <xsl:call-template name="new-file-psml-schematron"><xsl:with-param name="config" select="$psml-config"/></xsl:call-template>
    </xsl:when>
    <xsl:when test="@mediatype = 'text/css' and contains(@path, '/psml/')">
      <xsl:call-template name="new-file-psml-css"><xsl:with-param name="config" select="tokenize(@path, '/')[last()-2]"/></xsl:call-template>
    </xsl:when>
    <xsl:when test="@mediatype = 'text/css'">
      <xsl:call-template name="new-file-css"/>
    </xsl:when>
    <xsl:when test="@mediatype = 'application/javascript'">
      <xsl:call-template name="new-file-js"/>
    </xsl:when>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
