<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='password-change']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Password change')"/>
</xsl:template>

<xsl:template match="root[@service='password-change']" mode="main-content">
<xsl:variable name="member" select="//content/member"/>
<xsl:variable name="token" select="//parameter[@name='token']"/>
<div class="main-content">
  <main-panel>
    <centered-box>
      <update-password-form v-bind:member="{if ($member) then f:to-json($member) else 'null'}" token="{$token}"/>
    </centered-box>
  </main-panel>
</div>
</xsl:template>

</xsl:stylesheet>
