<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='error']" mode="html-title" as="xs:string*">
  <xsl:variable name="error-title">
    <xsl:choose>
      <xsl:when test="content/http-code='200'">OK</xsl:when>
      <xsl:when test="content/http-code='400'">Bad request</xsl:when>
      <xsl:when test="content/http-code='401'">Unauthorized</xsl:when>
      <xsl:when test="content/http-code='402'">License required</xsl:when>
      <xsl:when test="content/http-code='403'">Forbidden</xsl:when>
      <xsl:when test="content/http-code='404'">Page not found</xsl:when>
      <xsl:when test="content/http-code='405'">Method not allowed</xsl:when>
      <xsl:when test="content/http-code='500'">Internal server error</xsl:when>
      <xsl:when test="content/http-code='501'">Not implemented</xsl:when>
      <xsl:when test="content/http-code='502'">Bad gateway</xsl:when>
      <xsl:when test="content/http-code='503'">Service unavailable</xsl:when>
      <xsl:otherwise>Error</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:sequence select="($error-title)"/>
</xsl:template>

<xsl:template match="root[@service='error']" mode="main-content">
<div class="main-content">
  <main-panel>
    <centered-box>
      <xsl:for-each select="content[http-code]">
        <xsl:variable name="parameters">
          <json:array>
            <xsl:for-each select="//http-parameters/parameter">
              <json:map>
                <json:string key="name"><xsl:value-of select="@name"/></json:string>
                <json:string key="value"><xsl:value-of select="text()"/></json:string>
              </json:map>
            </xsl:for-each>
          </json:array>
        </xsl:variable>
        <xsl:variable name="collected-errors">
          <json:array>
            <xsl:for-each select="//collected-errors/error">
              <json:map>
                <json:string key="level"><xsl:value-of select="@level"/></json:string>
                <xsl:if test="@line">
                  <json:number key="line"><xsl:value-of select="@line"/></json:number>
                </xsl:if>
                <xsl:if test="@column">
                  <json:number key="column"><xsl:value-of select="@column"/></json:number>
                </xsl:if>
                <json:string key="location"><xsl:value-of select="@location"/></json:string>
                <json:string key="message"><xsl:value-of select="message"/></json:string>
              </json:map>
            </xsl:for-each>
          </json:array>
        </xsl:variable>

        <error-info v-bind:collected-errors="{f:xml-to-json($collected-errors)}"
                    v-bind:http-code="{http-code}"
                    v-bind:parameters="{f:xml-to-json($parameters)}"
                    build-number="{//constants/@build-number}"
                    http-method="{http-method}"
                    message="{message}"
                    referer="{referer}"
                    request-uri="{request-uri}"
                    host="{host}"
                    server-time="{datetime}"
                    servlet="{servlet}"
                    session-id="{//session/@id}"
                    stacktrace="{stacktrace}"
                    user-agent="{user-agent}">
          <xsl:choose>
            <xsl:when test="http-code = '200'">
              <p>This is a test page. You probably landed here by mistake.</p>
            </xsl:when>
            <xsl:when test="http-code = '400'">
              <p>The system is unable to accept your request for the following reason:</p>
              <p><b><xsl:value-of select="message"/></b></p>
            </xsl:when>
            <xsl:when test="http-code = '401'">
              <p>Access to this page requires authentication, please <a href="{$site-prefix}/ui/signin.html" title="Sign in">sign in</a>.</p>
            </xsl:when>
            <xsl:when test="http-code = '402'">
              <p>The product key for this server is not valid.</p>
              <p>Please contact your administrator or update the license.</p>
            </xsl:when>
            <xsl:when test="http-code = '403'">
              <p>You are not allowed to access this page.</p>
            </xsl:when>
            <xsl:when test="http-code = '404'">
              <p>The system is unable to find the page you requested.</p>
            </xsl:when>
            <xsl:when test="http-code = '405'">
              <p>The page that you requested cannot be accessed this way.</p>
            </xsl:when>
            <xsl:when test="http-code = '500'">
              <p>We're sorry, but something went wrong and this page isn't working.</p>
            </xsl:when>
            <xsl:when test="http-code = '501'">
              <p>We're sorry, but the system is unable to fulfill your request.</p>
            </xsl:when>
            <xsl:when test="http-code = '502'">
              <p>We're sorry, but the system is down.</p>
            </xsl:when>
            <xsl:when test="http-code = '503'">
              <p>We're sorry, but the system is temporarily down or being upgraded. Try again in a few minutes.</p>
              <upgrade-progress />
            </xsl:when>
          </xsl:choose>

        </error-info>
      </xsl:for-each>
    </centered-box>
  </main-panel>
</div>
</xsl:template>

</xsl:stylesheet>
