<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='email-change']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Email change')"/>
</xsl:template>

<xsl:template match="root[@service='email-change']" mode="main-content">
<div class="main-content">
  <main-panel>
    <centered-box>
      <public-content>
        <xsl:variable name="member" select="//member-modification/member"/>
        <xsl:choose>

          <!-- Email changed -->
          <xsl:when test="$member">
            <h1 class="page-title">Email changed</h1>
            <translucent-fieldset>
              <p>Hi <xsl:value-of select="$member/@firstname" />,
                your email has been changed to <b><xsl:value-of select="$member/@email" /></b></p>
            </translucent-fieldset>
          </xsl:when>

          <!-- Error (TOKEN_INVALID) -->
          <xsl:when test="//error[@id='102A']">
            <h1 class="page-title">Invalid email link</h1>
            <callout-box type="warning">
              <p>We were unable to change your email address because this link is no longer valid.</p>
              <p>Return to your <a href="{$site-prefix}/ui/account/personal.html">personal profile</a> to try changing your email address again.</p>
            </callout-box>
          </xsl:when>

          <!-- Error (USER_EXISTS) -->
          <xsl:when test="//error[@id='1004']">
            <h1 class="page-title">Email already in use</h1>
            <callout-box type="warning" text="We were unable to change your email address because it is already in use."/>
          </xsl:when>

          <xsl:otherwise>
            <h1 class="page-title">Change email</h1>
            <callout-box type="error" text="We were unable to change your email address"/>
          </xsl:otherwise>

        </xsl:choose>

        <p><a href="{$site-prefix}/ui/home.html" class="button">Return to PageSeeder</a></p>
      </public-content>
    </centered-box>
  </main-panel>
</div>
</xsl:template>

</xsl:stylesheet>