<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='group-activity']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Document activity')"/>
</xsl:template>

<xsl:template match="root[@service='group-activity']" mode="main-content">
  <xsl:variable name="group"       select="//context/group"/>
  <xsl:variable name="types"       select="//http-parameters/parameter[@name='types']"/>
  <xsl:variable name="author"      select="//http-parameters/parameter[@name='author']"/>
  <xsl:variable name="doctypes"    select="//http-parameters/parameter[@name='doctype']"/>
  <xsl:variable name="location"    select="//http-parameters/parameter[@name='location']"/>
  <xsl:variable name="publication" select="//http-parameters/parameter[@name='publication']"/>

  <xsl:variable name="activities"  select="('upload', 'creation', 'modification', 'structure', 'draft',
                                            'edit', 'xref', 'image', 'version', 'revert', 'note', 'comment', 'workflow', 'task', 'move')"/>

  <xsl:variable name="default-guri" select="//groupfolders/groupfolder[@path = concat($site-prefix, '/', replace($group/@name, '-', '/'), '/*')]" />
  <xsl:variable name="default-port" select="if (($default-guri/@scheme = 'http'  and $default-guri/@port = '80') or
                                                ($default-guri/@scheme = 'https' and $default-guri/@port = '443')) then '' else concat(':', $default-guri/@port)" />

  <!-- document types -->
  <xsl:variable name="all-document-types">
    <json:array>
      <xsl:for-each select="//document-types/document-type">
        <json:map>
          <json:string key="value"><xsl:value-of select="@name" /></json:string>
          <json:string key="name"><xsl:value-of select="if (document-config/creation/title) then document-config/creation/title else @name" /></json:string>
          <xsl:if test="document-config/creation/description">
            <json:string key="description"><xsl:value-of select="document-config/creation/description" /></json:string>
          </xsl:if>
          <xsl:if test="@icon">
            <json:string key="icon"><xsl:value-of select="$site-prefix" /><xsl:value-of select="@icon" /></json:string>
          </xsl:if>
        </json:map>
      </xsl:for-each>
    </json:array>
  </xsl:variable>

  <xsl:variable name="event-types">
    <json:array>
      <xsl:choose>
        <xsl:when test="$types">
          <xsl:for-each select="tokenize($types, ',')">
            <json:string><xsl:value-of select="."/></json:string>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <xsl:for-each select="('comment','edit','structure','task','workflow','modification')">
            <json:string><xsl:value-of select="."/></json:string>
          </xsl:for-each>
        </xsl:otherwise>
      </xsl:choose>
    </json:array>
  </xsl:variable>

  <!-- publications -->
  <xsl:variable name="all-publications">
    <json:array>
      <xsl:apply-templates select="content/publications/publication" mode="json" />
    </json:array>
  </xsl:variable>

  <nav class="bar-content">

    <activity-bar v-bind:types="[{string-join(for $i in $activities return concat('&quot;', $i, '&quot;'), ',')}]"
                  v-bind:document-types="{f:xml-to-json($all-document-types)}"
                  v-bind:initial-types="{f:xml-to-json($event-types)}"
                  v-bind:initial-document-types="[{string-join(for $i in tokenize($doctypes, ',') return concat('&quot;', $i, '&quot;'), ',')}]"
                  v-bind:publications="{f:xml-to-json($all-publications)}"
                  group-name="{$group/@name}"
                  base-url="{$default-guri/@scheme}://{$default-guri/@host}{$default-port}"
                  initial-location="{$location}"
                  initial-from="last-30"
                  initial-publication="{$publication}"/>

  </nav>

  <div class="main-content">
    <main-panel>
      <group-activity group-name="{$group/@name}"/>
    </main-panel>
    <side-panel side="right" v-bind:width="800"/>
  </div>

</xsl:template>

</xsl:stylesheet>
