<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" exclude-result-prefixes="#all">

<!-- Import common stylesheets here -->
<xsl:import href="common/app.xsl"/>
<xsl:import href="common/functions.xsl"/>
<xsl:import href="common/app-content.xsl"/>
<xsl:import href="common/side-nav.xsl"/>
<xsl:import href="common/json.xsl"/>

<!-- Common JSON/PSML code -->
<xsl:import href="../_common/json.xsl"/>
<xsl:import href="../_common/psml.xsl"/>

<!-- Import stylesheets specific to each service here -->
<xsl:import href="group/group-comment-moderate.xsl"/>
<xsl:import href="group/group-discussions.xsl"/>
<xsl:import href="group/group-home.xsl"/>
<xsl:import href="group/group-search.xsl"/>
<xsl:import href="group/group-members.xsl"/>
<xsl:import href="group/group-tasks.xsl"/>
<xsl:import href="group/group-activity.xsl"/>
<xsl:import href="group/group-urls.xsl"/>

<!-- General Output properties. -->
<xsl:output method="html" encoding="utf-8" indent="no" media-type="text/html" undeclare-prefixes="no" version="5.0" />

<!--
  Main template called in all cases.
-->
<xsl:template match="/">
<!-- We declare a namespace for Vue here so that its is not redeclare later for each `v-bind` -->
<html lang="en" xmlns:v-bind="https://vuejs.org">
  <xsl:apply-templates select="root" mode="html-head"/>
  <xsl:apply-templates select="root" mode="html-body"/>
</html>
</xsl:template>

</xsl:stylesheet>
