<?xml version="1.0"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->

<!--
  This stylesheet usually contains common application specific templates
-->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xs="http://www.w3.org/2001/XMLSchema"
                              xmlns:f="http://www.pageseeder.com/function"
                              exclude-result-prefixes="#all">

<!--
  Set of all known group properties for use by functions.
  DO NOT reference this variable outside.
-->
<xsl:variable name="_groupproperties">
  <!-- TODO Remove now only used for project properties -->
  <set>
    <properties name="Document">
      <property>documentStatusInitial</property>
      <property>documentStatusApprover</property>
      <property>documentStatusManager</property>
      <property>documentStatusContributor</property>
      <property>documentStatusReviewer</property>
      <property>documentStatusLocked</property>
      <property>contentEditorName</property>
      <property type="boolean">supportStandardFormat</property>
    </properties>
    <properties name="Task">
      <property>priority</property>
      <property>statusActive</property>
      <property>statusApprover</property>
      <property>statusManager</property>
      <property>statusContributor</property>
      <property>statusReviewer</property>
      <property>statusBroadcastApprovers</property>
    </properties>
    <properties name="Notification">
      <property>notifyFromAddress</property>
      <property type="boolean">mailNewThreadByTitle</property>
      <property>mailRejectedAddress</property>
      <property>mailReturnedAddress</property>
      <property type="boolean">reminderNotification</property>
      <property type="boolean">stripHtmlEmailFooter</property>
      <property>emailFooterStart</property>
      <property>emailFooterEnd</property>
      <property>ignoreEmbeddedAttachmentSize</property>
    </properties>
    <properties name="Interface">
      <property title="Help URL">helpUrl</property>
      <property title="Calendar URL">calendarUrl</property>
      <property title="Header logo URL">headerLogoUrl</property>
      <property title="Custom CSS">customCss</property>
    </properties>
    <properties name="Index">
      <property type="boolean">disableIndexing</property>
      <property>indexIgnoreFolders</property>
      <property type="boolean">indexVersions</property>
      <property type="boolean" title="Index X-Fields">indexXFields</property>
    </properties>
  </set>
</xsl:variable>

<!--
  Returns a printable version of the group property
  i.e.: notifyFromAddress -> Notify From Address

  @param property Group property
-->
<xsl:function name="f:format-group-property">
  <xsl:param name="property" />
  <!-- TODO Update to capitalize properly -->
  <xsl:value-of select="normalize-space(concat(upper-case(substring($property, 1, 1)), string-join(
          for $i in 2 to string-length($property) return
            if (matches(substring($property, $i, 1), '[A-Z]')) then concat(' ', substring($property, $i, 1))
            else substring($property, $i, 1), '')))" />
</xsl:function>

<!--
  Returns the title for this group property

  @param name Name of the group property
-->
<xsl:function name="f:group-property-title">
  <xsl:param name="name" as="xs:string"/>
  <xsl:variable name="definition" select="$_groupproperties//property[text() = $name]"/>
  <xsl:value-of select="if ($definition/@title) then $definition/@title else f:format-group-property($name)" />
</xsl:function>

</xsl:stylesheet>
