<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2020 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:json="http://www.w3.org/2005/xpath-functions"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='project-admin-types']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Template configuration')"/>
</xsl:template>

<xsl:template match="root[@service='project-admin-types']" mode="main-content">
<div class="main-content">
  <main-panel>

    <xsl:variable name="global-template" select="//constants/@global-template"/>
    <xsl:variable name="current-project" select="//context/project/@name"/>
    <xsl:variable name="default-bundles" select="content[@name='list-default-bundles']//bundle"/>
    <xsl:variable name="project-bundles" select="content[@name='list-project-bundles']//bundle"/>

    <xsl:variable name="publication-bundles" select="f:_merge-bundles($default-bundles[@type='publication']|$project-bundles[@type='publication'])"/>
    <xsl:variable name="psml-bundles" select="f:_merge-bundles($default-bundles[@type='psml-document']|$project-bundles[@type='psml-document'])"/>
    <xsl:variable name="media-bundles" select="f:_merge-bundles($default-bundles[@type='document']|$project-bundles[@type='document'])"/>
    <xsl:variable name="url-bundles" select="f:_merge-bundles($default-bundles[@type='url']|$project-bundles[@type='url'])"/>

    <xsl:variable name="project-template" select="content/context/project/@template" />
    <xsl:choose>
      <xsl:when test="contains($current-project, '-') and $current-project != $project-template">
        <h1 class="page-title"><svg-icon name="file-template" /> Template configuration</h1>
        <p>This subproject uses the <a
            href="{$site-prefix}/ui/p/{$project-template}/admin/types.html"><xsl:value-of select="$project-template" />
        </a> template configuration. <br />
          To make different customizations for this subproject change the template under <a
              href="{$site-prefix}/ui/p/{$current-project}/admin/config.html">project configuration</a>.</p>
      </xsl:when>
      <xsl:otherwise>
        <project-admin-types project-name="{$current-project}"
                             v-bind:publication-bundles="{f:xml-to-json($publication-bundles)}"
                             v-bind:psml-bundles="{f:xml-to-json($psml-bundles)}"
                             v-bind:media-bundles="{f:xml-to-json($media-bundles)}"
                             v-bind:url-bundles="{if ($current-project != $global-template) then 'null' else f:xml-to-json($url-bundles)}" />
      </xsl:otherwise>
    </xsl:choose>

  </main-panel>
  <side-panel side="right" v-bind:width="800"/>
</div>
</xsl:template>

<xsl:function name="f:_merge-bundles" as="element(json:array)">
  <xsl:param name="bundles" as="element(bundle)*"/>
  <json:array>
    <xsl:for-each-group select="$bundles" group-by="@name">
      <xsl:sort select="@name"/>
      <json:map>
        <json:string key="name"><xsl:value-of select="@name"/></json:string>
        <json:string key="folder">
          <xsl:choose>
            <xsl:when test="@type = 'psml-document'">psml</xsl:when>
            <xsl:when test="@type = 'publication'">publication</xsl:when>
            <xsl:when test="@type = 'document'">document</xsl:when>
            <xsl:when test="@type = 'url'">url</xsl:when>
          </xsl:choose>
        </json:string>
        <json:array key="files">
          <xsl:apply-templates select="current-group()/file" mode="project-types-json"/>
        </json:array>
      </json:map>
    </xsl:for-each-group>
  </json:array>
</xsl:function>

<!-- Returns the file as JSON -->
<xsl:template match="file" mode="project-types-json">
  <xsl:if test="not(@status = 'not-found')">
    <json:map>
      <json:string key="name"><xsl:value-of select="@name"/></json:string>
      <json:string key="type"><xsl:value-of select="@type"/></json:string>
      <json:string key="path"><xsl:value-of select="@path"/></json:string>
      <json:number key="length"><xsl:value-of select="if (@length) then @length else 0"/></json:number>
      <json:string key="mediatype"><xsl:value-of select="@mediatype"/></json:string>
      <json:string key="modified"><xsl:value-of select="@modified"/></json:string>
      <json:string key="definedby"><xsl:value-of select="@definedby"/></json:string>
      <json:string key="role"><xsl:value-of select="@role"/></json:string>
      <json:boolean key="text"><xsl:value-of select="@text = 'true'"/></json:boolean>
      <json:boolean key="editable"><xsl:value-of select="@editable = 'true'"/></json:boolean>
    </json:map>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
