<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='project-admin-labels']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Labels')"/>
</xsl:template>

<xsl:template match="root[@service='project-admin-labels']" mode="main-content">
<div class="main-content">
  <main-panel>

    <xsl:variable name="project-template" select="content/context/project/@template" />
    <xsl:choose>
      <xsl:when test="contains($current-project, '-') and $current-project != $project-template">
        <h1 class="page-title"><svg-icon name="file-template" /> Labels</h1>
        <p>This subproject uses the <a
            href="{$site-prefix}/ui/p/{$project-template}/admin/labels.html"><xsl:value-of select="$project-template" />
        </a> template labels. <br />
          To make different customizations for this subproject change the template under <a
            href="{$site-prefix}/ui/p/{$current-project}/admin/config.html">project configuration</a>.</p>
      </xsl:when>
      <xsl:otherwise>
        <admin-labels project="{$current-project}" global-save=""
                      v-bind:initial-labels="{f:to-json-all-labels(content/label-config, content/document-types, content//xref-configs)}">
          <xsl:if test="string(content/label-config/@template) != $current-project">
            <xsl:attribute name="using-default" />
          </xsl:if>
        </admin-labels>
      </xsl:otherwise>
    </xsl:choose>

  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
