<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2020 Allette Systems Pty Ltd
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                xmlns:f="http://www.pageseeder.com/function"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='group-admin-maintenance']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Group maintenance')"/>
</xsl:template>

<xsl:template match="root[@service='group-admin-maintenance']" mode="main-content">
<div class="main-content">
  <xsl:variable name="group" select="content/context/group" />
  <main-panel>
    <h1 class="page-title"><svg-icon name="cog"/> Group maintenance</h1>

    <xsl:choose>
      <xsl:when test="empty($group)">
        <p>Invalid group <xsl:value-of select="header//parameter[@name='group']" />.</p>
      </xsl:when>
      <xsl:otherwise>
        <group-maintenance v-bind:group="{f:to-json($group)}"
                           group-index-version="{$group/@indexversion}"
                           system-index-version="{//constants/@index-version}"
                           v-bind:index-versions-allowed="{content//property[@name='indexVersions']/@value = 'true'}"
                           v-bind:index-disabled="{content//property[@name='disableIndexing']/@value = 'true'}" />
      </xsl:otherwise>
    </xsl:choose>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
