<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-projects-archived']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Archived projects &amp; groups')"/>
</xsl:template>

<xsl:template match="root[@service='admin-projects-archived']" mode="main-content">
<div class="main-content">
  <main-panel>
    <h1 class="page-title"><svg-icon name="group"/> Archived projects &amp; groups</h1>

    <callout-box type="warning">
      <ul>
        <li>Unarchiving a group will restore all its contents.</li>
        <li>Unarchiving a project will restore all its template files.</li>
        <li>The parent project must exist for a group or subproject to be unarchived.</li>
      </ul>
    </callout-box>

    <admin-projects-archived />

  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
