<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2018 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='admin-logs-general']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('General logs')"/>
</xsl:template>

<xsl:template match="root[@service='admin-logs-general']" mode="main-content">
<div class="main-content">
  <xsl:variable name="date" select="header//parameter[@name = 'date']" />
  <xsl:variable name="time" select="header//parameter[@name = 'time']" />
  <main-panel>

    <xsl:call-template name="current-server-datetime"/>

    <h1 class="page-title"><svg-icon name="logs"/> General logs</h1>

    <general-logs initial-date="{if($date) then $date else substring(string(current-date()), 1, 10)}"
                  initial-time="{$time}" />

  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
