<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright (c) 1999-2019 Allette Systems Pty Ltd
  -->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:f="http://www.pageseeder.com/function"
                xmlns:v-bind="https://vuejs.org"
                exclude-result-prefixes="#all">

<xsl:template match="root[@service='account-home']" mode="html-title" as="xs:string*">
  <xsl:sequence select="('Home')"/>
</xsl:template>

<xsl:template match="root[@service='account-home']" mode="main-content">
<div class="main-content">
  <main-panel>
    <div class="container">
      <account-home v-bind:invitations="{f:to-json-array(content/invitations/membership)}"
                    v-bind:widgets="{f:to-json-array(content/ui/account-home/widget)}"
                    v-bind:links="{f:to-json-array(content/ui/account-home/link)}" />
    </div>
    <xsl:call-template name="app-footer"/>
  </main-panel>
  <side-panel side="right"/>
</div>
</xsl:template>

</xsl:stylesheet>
