<?xml version="1.0"?>
<!--
  Template used when a URL is created or edited

  @version 5.8900
-->
<xsl:stylesheet version="2.0"
        xmlns:f="http://www.pageseeder.com/function"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="#all">

<xsl:import href="_text.xsl"/>

<xsl:template match="/notification[@template='new-uri']">
<xsl:if test="@announcement = 'true'">
NOTE: This email has been sent to you regardless of your <xsl:value-of select="$appname" /> notification settings because it is an announcement.
</xsl:if>
<xsl:for-each select="message/labels[text() != '' and text() != ',']">
LABELS: <xsl:value-of select="string-join(tokenize(., ','), ', ')" />
</xsl:for-each>
<xsl:for-each select="message/attachment/uri">
----------------------------------------------------------------------
ATTACHMENT: <xsl:value-of select="displaytitle" />
VIEW/DOWNLOAD:
  <xsl:value-of select="concat($linksprefix, '/uri?group=', ../../../group/@name, '&amp;uri=', @id)" />
</xsl:for-each>
----------------------------------------------------------------------

<xsl:value-of select="message/content[contains(@type,'text/plain')]" />

----------------------------------------------------------------------
You received this message because you are part of group <xsl:value-of select="group/@name"/>.
If you wish to change your notification settings, you can do so by visiting the unsubscribe page
  <xsl:value-of select="concat($linksprefix, '/unsubscribe?group=', group/@name, '&amp;token=', @unsubscribetoken)" />

This is an automatically generated email - please do not reply to this email.
</xsl:template>

</xsl:stylesheet>