<!--
  Indexing transformations for PNG images.

  The source XML follows the structure below:

  ```
    <index-data mediatype="image/png">
      <document level="metadata"> ... </document>
      <workflow> ... </workflow>
      <content source="tika"> ... </content>
    </index-data>
  ```

  @author Christophe Lauret
  @author Jean-Baptiste Reure

  @version 5.9000
-->
<xsl:transform  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:psf="http://www.pageseeder.com/function"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                exclude-result-prefixes="#all">

<!-- We extend the default index module -->
<xsl:import href="index.xsl" />

<!-- indexXFields group property -->
<xsl:param name="ps-indexXFields" select="'false'" />


<!-- 
  Generate the fields specific to PNG from content extracted by Tika.

  ```
  <content source="tika">
    <html xmlns="http://www.w3.org/1999/xhtml">
      <head>
        <meta name="width" content="xxx"/>
        <meta name="height" content="yyy"/>
        ...
      </head>
      <body/>
    </html>
  </content>
  ```
-->
<xsl:template match="index-data[@mediatype='image/png']/content" mode="ixml" priority="2">
  <xsl:for-each select="descendant::xhtml:head">

    <!-- Image dimensions -->
    <xsl:if test="xhtml:meta[@name = 'width'] and xhtml:meta[@name = 'height']">
      <xsl:sequence select="psf:ps-dimension(xhtml:meta[@name = 'width']/@content, xhtml:meta[@name = 'height']/@content)"/>
    </xsl:if>
    
    <xsl:sequence select="psf:exif-media-dates(., /index-data/document/documentinfo/uri/@created)" />

    <!-- Metadata reported by Tika if any -->
    <xsl:for-each select="xhtml:meta[not(@name = 'X-Parsed-By' or @name = 'Content-type')][$ps-indexXFields = 'true']">
      <xsl:sort select="lower-case(@name)"/>
      <xsl:sequence select="psf:x-field(@name, @content)"/>
    </xsl:for-each>

  </xsl:for-each>  
</xsl:template>

</xsl:transform>
