<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="#all">

  <xsl:param name="version" />

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="links">
    <sankey>
      <!-- First step that is the first node -->
      <xsl:apply-templates mode="first-step"/>

      <!-- Second step that is the Second node -->
      <xsl:apply-templates mode="second-step"/>

      <!-- Third step that is the Third node -->
      <xsl:apply-templates mode="third-step"/>
    </sankey>
  </xsl:template>

  <!-- First group of node  -->
  <xsl:template match="link" mode="first-step">
    <xsl:variable name="current" select="."/>
    <!-- Only if there isn't other previous sibling with this same combination -->
    <xsl:if test="(count(./preceding-sibling::link[@owner_directory = $current/@owner_directory and @type = $current/@type]) = 0)">
      <xsl:variable name="weight" select="count(./following-sibling::link[@owner_directory = $current/@owner_directory and @type = $current/@type]) + 1"/>
      <entry>
        <xsl:attribute name="from"><xsl:value-of select="@owner_directory"/></xsl:attribute>
        <xsl:attribute name="to"><xsl:value-of select="if (@type = 'p') then 'PSML' else 'Other'"/></xsl:attribute>
        <xsl:attribute name="weight"><xsl:value-of select="$weight"/></xsl:attribute>
      </entry>
   </xsl:if>
  </xsl:template>

  <!-- Second group of node  -->
  <xsl:template match="link" mode="second-step">
    <xsl:variable name="current" select="."/>
    <!-- Only if there isn't other previous sibling with this same combination -->
    <xsl:if test="(count(./preceding-sibling::link[@type = $current/@type and @element = $current/@element]) = 0)">
      <xsl:variable name="weight" select="count(./following-sibling::link[@type = $current/@type and @element = $current/@element]) + 1"/>
      <entry>
        <xsl:attribute name="from"><xsl:value-of select="if (@type = 'p') then 'PSML' else 'Other'" /></xsl:attribute>
        <xsl:attribute name="to"><xsl:value-of select="@element"/></xsl:attribute>
        <xsl:attribute name="weight"><xsl:value-of select="$weight"/></xsl:attribute>
      </entry>
   </xsl:if>
  </xsl:template>


  <!-- Third group of node  -->
  <xsl:template match="link" mode="third-step">
    <xsl:variable name="current" select="."/>
    <!-- Only if there isn't other previous sibling with this same combination -->
    <xsl:if test="(count(./preceding-sibling::link[@target_directory = $current/@target_directory and @element = $current/@element]) = 0)">
      <xsl:variable name="weight" select="count(./following-sibling::link[@target_directory = $current/@target_directory and @element = $current/@element]) + 1"/>
      <entry>
        <xsl:attribute name="from"><xsl:value-of select="@element"/></xsl:attribute>
        <xsl:attribute name="to"><xsl:value-of select="@target_directory"/></xsl:attribute>
        <xsl:attribute name="weight"><xsl:value-of select="$weight"/></xsl:attribute>
      </entry>
   </xsl:if>
  </xsl:template>
</xsl:stylesheet>