/**
 * $Id: DefinedValueURIHandlerTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.valueuri.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ValueURIHandler;
import  com.idaremedia.antx.helpers.Strings;
import  com.idaremedia.antx.valueuri.condition.DefinedValueURIHandler;

/**
 * Testsuite for {@linkplain DefinedValueURIHandler}.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    impl,test
 **/

public final class DefinedValueURIHandlerTest extends ValueURIHandlerTestSkeleton
{
    /**
     * Initializes a new test case for named method.
     * @param methodname test case method's name (non-null)
     **/
    public DefinedValueURIHandlerTest(String methodname)
    {
        super("DefinedValueURIHandler::",methodname);
    }


    /**
     * Returns full test suite for DefinedValueURIHandler.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(DefinedValueURIHandlerTest.class);
    }

//  ---------------------------------------------------------------------------------------------------------
//  --------------------------------------- [ Misc Factory Methods ] ----------------------------------------
//  ---------------------------------------------------------------------------------------------------------

    protected ValueURIHandler newOUT()
    {
        return new DefinedValueURIHandler();
    }

//  ---------------------------------------------------------------------------------------------------------
//  ------------------------------------------- [ The Test Cases ] ------------------------------------------
//  ---------------------------------------------------------------------------------------------------------

    private void assertIsTrue(String value, String what)
    {
        assertEqual(value,Strings.TRUE,"$defined:"+what);
    }


    private void assertIsFalse(String value, String what)
    {
        assertEqual(value,Strings.FALSE,"$defined:"+what);
    }


    /**
     * Verify we can generate a project-unique reference always.
     * @since JWare/AntX 0.5
     **/
    public void testBaseline_AntX05()
    {
        checkBaseline();

        ValueURIHandler out = newOUT();
        assertIsFalse(out.valueFrom("","$defined:",m_rqlink),"[:empty:]");
    }



    /**
     * Verifies we evaluate 'true' for defined and resolvable
     * properties.
     * @since JWare/AntX 0.5
     **/
    public void testGoodProperty_AntX05()
    {
        getProject().setProperty("seekrit","ssshhh");
        ValueURIHandler out = newOUT();
        
        String result = out.valueFrom("seekrit?property","$defined:seekrit?property",m_rqlink);
        assertIsTrue(result,"seekrit?property");
        result = out.valueFrom("${seekrit}","$defined:${seekrit}",m_rqlink);
        assertIsTrue(result,"${seekrit}");
        result = out.valueFrom("@(seekrit)","$defined:@(seekrit)",m_rqlink);
        assertIsTrue(result,"${seekrit}");
    }
 
 

    /**
     * Verifies we evaluate 'false' for defined but malformed
     * properties.
     * @since JWare/AntX 0.5
     **/
    public void testMalformedProperty_AntX05()
    {
        getProject().setProperty("malformed","a${non-existing}value");
        ValueURIHandler out = newOUT();
        
        String result = out.valueFrom("malformed?property","$defined:malformed?property",m_rqlink);
        assertIsFalse(result,"malformed?property");
        result = out.valueFrom("${malformed}","$defined:${malformed}",m_rqlink);
        assertIsFalse(result,"${malformed}");
        result = out.valueFrom("@(malformed)","$defined:@(malformed)",m_rqlink);
        assertIsFalse(result,"@(malformed)");
    }



    /**
     * Verifies we evaluate 'false' for undefined properties.
     * @since JWare/AntX 0.5
     **/
    public void testUndefinedProperty_AntX05()
    {
        ValueURIHandler out= newOUT();
        
        String result = out.valueFrom("nosuchproperty?property","$defined:nosuchproperty?property",m_rqlink);
        assertIsFalse(result,"nosuchproperty?property");
        result = out.valueFrom("@(nosuchproperty)","$defined:@(nosuchproperty)",m_rqlink);
        assertIsFalse(result,"@(nosuchproperty)");
    }
    


    /**
     * Verifies we evaluate 'false' for all whitespace literals and
     * property values.
     * @since JWare/AntX 0.5 
     **/
    public void testAllWhitespaceValues_AntX05()
    {
        getProject().setProperty("whitespace","  \t");       
        ValueURIHandler out = newOUT();
        
        String result = out.valueFrom("${whitespace}","$defined:${whitespace}",m_rqlink);
        assertIsFalse(result,"${whitespace}");
        result = out.valueFrom(" \t ","$defined: \t ",m_rqlink);
        assertIsFalse(result,"[:space:]");
    }
    


    /**
     * Verifies we evaluate 'false' for all empty string literals and
     * property values.
     * @since JWare/AntX 0.5 
     **/
    public void testEmptyValues_AntX05()
    {
        getProject().setProperty("empty","");
        ValueURIHandler out = newOUT();
        
        String result = out.valueFrom("@(empty)","$defined:@(empty)",m_rqlink);
        assertIsFalse(result,"@([:empty:])");
        assertIsFalse(out.valueFrom("","$defined:",m_rqlink),"[:empty:]");
    }
}

/* end-of-DefinedValueURIHandlerTest.java */