/**
 * $Id: EchoItemsTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.print.EchoItemsTask EchoItemsTask}.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public class EchoItemsTaskTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new EchoItemsTaskTest testcase.
     **/
    public EchoItemsTaskTest(String methodName)
    {
        super("EchoItemsTask::",methodName);
    }


    /**
     * Create full test suite for AssertTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(EchoItemsTaskTest.class);
    }


    /**
     * Create baseline test suite for AssertTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("echo.xml");
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    public void testEchoStringLiteral()
    {
        String log = runTarget("testEchoPlainStringLiteral");
        assertTrue(log.indexOf("Throatwobblermangrove")>-1,"Found 'wobbler' bits");
    }

    public void testEchoProperties()
    {
        String log = runTarget("testEchoProperties");
        assertTrue(log.indexOf("spam")>-1,"Found 'spam' marker");
        assertTrue(log.indexOf("ant.file=")>-1,"Found 'ant.file' bits");
    }

    public void testEchoVariables()
    {
        String log = runTarget("testEchoVariables");
        assertTrue(log.indexOf("spam")>-1,"Found 'spam' marker");
        assertTrue(log.indexOf("var.1=")>-1,"Found 'var.1' bits");
    }

    public void testEchoReferences()
    {
        String log = runTarget("testEchoReferences");
        assertTrue(log.indexOf("spam")>-1,"Found 'spam' marker");
        assertTrue(log.indexOf("baseline.srcs")>-1,"Found 'baseline.srcs' bits");
    }

    public void testEchoAllOfEverythingToFiles()
    {
        runTargetNoOutput("testEchoAllOfEverything");
    }

    public void testEchoFilteredReferences()
    {
        String log = runTarget("testEchoKindOfReferences");
        assertTrue(log.indexOf("non.tests.srcs")>-1,"Found 'non.tests.srcs' bits");
        assertTrue(log.indexOf("baseline.srcs")>-1,"Found 'baseline.srcs' bits");
        assertTrue(log.indexOf("etc.dirs") == -1,"Didn't find 'dirset' bits");
    }

    public void testEchoFilteredProperties()
    {
        String log = runTarget("testEchoPrefixedProperties");
        assertTrue(log.indexOf("ant.file")>-1,"Found 'ant.file' bits");
        assertTrue(log.indexOf("p.true") == -1,"Didn't find 'p.true' bits");
    }


    public void testPrintAntXDomains_AntX04()
    {
        runTargetNoOutput("testPrintAntXDomains_AntX04");
    }
}


/* end-of-EchoItemsTaskTest.java */
