/**
 * $Id: AssertionRuleTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  junit.framework.TestSuite;
import  org.apache.tools.ant.BuildException;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

import  com.idaremedia.antx.apis.BuildAssertionException;

/**
 * Class test for {@linkplain com.idaremedia.antx.condition.AssertTask AssertTask}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public class AssertionRuleTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new AssertionRuleTest testcase.
     **/
    public AssertionRuleTest(String methodName)
    {
        super("AssertTask::",methodName);
    }


    /**
     * Create full test suite for AssertTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(AssertionRuleTest.class);
    }


    /**
     * Create baseline test suite for AssertTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("assert.xml");
    }

    protected void expectViolation(String target, String cause, String msg)
        throws Exception
    {
        try {
            executeTarget(target);
        } catch (BuildException ex) {
            Throwable t = ex.getException();
            println("*** THROWN: "+ex.getMessage());
            if (t!=null) {
                assertTrue((t instanceof BuildAssertionException), "Is Assertion Exception");
            }
            if ((null != msg) && (!ex.getMessage().equals(msg))) {
                fail("Should throw AssertionException because '" + cause
                        + "' with message '" + msg
                        + "' (actual message '" + ex.getMessage() + "' instead)");
            }
            return;
        }
        fail("Should throw AssertionException because: " + cause);
    }

    protected void expectViolation(String target, String cause, String msg, String pn, String pv)
         throws Exception
    {
        expectViolation(target,cause,msg);
        assertPropertyEquals(pn,pv);
    }


// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    public void testFailEmptyElement()
    {
        expectBuildExceptionContaining("undefined","Empty Assertion","At least one condition");
    }

    public void testPassNoFailProperty()
    {
        runTargetNoOutput("testNoFailProperty");
    }


    public void testSimpleTruths()
    {
        runTargetNoOutput("simple.truths");
        assertPropertyEquals("truth.istrue",null);
        assertPropertyEquals("truth.isfalse",null);
        assertPropertyEquals("truth.isset",null);
        assertPropertyEquals("truth.welcome",null);
        assertPropertyEquals("truth.isnotset",null);
        assertPropertyEquals("truth.varnotset",null);
        assertPropertyEquals("truth.notwhitespace",null);
        assertPropertyEquals("truth.antfile",null);
        assertPropertyEquals("truth.isnumeric",null);
        assertPropertyEquals("truth.ishexnumeric",null);
        assertPropertyEquals("truth.file",null);
        assertPropertyEquals("truth.dir",null);
        assertPropertyEquals("truth.resource",null);
        assertPropertyEquals("truth.class",null);
        assertPropertyEquals("truth.isref",null);
        assertPropertyEquals("truth.isnotref",null);
        assertPropertyEquals("broken.filenotempty",null);
    }

    public void testSimpleFalsehoods() throws Exception
    {
        expectViolation("not.istrue","false!=true",null,"falsehood.istrue","true");
        expectViolation("not.isfalse","true!=false",null,"falsehood.isfalse","true");
        expectViolation("not.isset","property-not-set",null,"falsehood.isset","true");
        expectViolation("not.isnotset","property-is-set",null,"falsehood.isnotset","true");
        expectViolation("not.isnotwhitespace","is-whitespace",null,"falsehood.isnotwhitespace","true");
        expectViolation("not.isnumeric","is-not-number",null,"falsehood.isnumeric","true");
        expectViolation("not.isnumeric2nd","empty-is-not-number",null,"falsehood.isnumeric2nd","true");
        expectViolation("not.isfile","is-not-file",null,"falsehood.isfile","fs.dink");
        expectViolation("not.isfile2","is-not-file2",null,"falsehood.isfile2","true");
        expectViolation("not.isdir","is-not-directory",null,"falsehood.isdir","fs.doink");
        expectViolation("not.isresource","is-not-resource",null,"falsehood.isrez","true");
        expectViolation("not.startswith","not-startswith",null,"falsehood.startswith","true");
        expectViolation("not.endswith","not-endswith",null,"falsehood.endswith","true");
        expectViolation("not.contains","not-contains",null,"falsehood.contains","true");
        expectViolation("not.equals","not-equals",null,"falsehood.equals","true");
        expectViolation("not.notequals","not-not-equals",null,"falsehood.notequals","true");
        expectViolation("not.isclass","not-isclass",null,"falsehood.isclass","true");
        expectViolation("not.isref","not-isref",null,"falsehood.isref","true");
        expectViolation("not.isnotref","not-isnotref",null,"falsehood.isnotref","true");
        expectViolation("not.filenotempty","not-filenotempty",null,"falsehood.filenotempty","true");
    }

    public void testSetsOfTruths()
    {
        runTargetNoOutput("testTruthsBySets");
        assertPropertyEquals("broken.allset",null);
        assertPropertyEquals("broken.noneset",null);
        assertPropertyEquals("broken.anyset",null);
    }

    public void testSetsOfFalsehoods() throws Exception
    {
        expectViolation("not.allset","not-allset",null,"falsehood.allset","true");
        expectViolation("not.noneset","not-noneset(mid)",null,"falsehood.noneset","true");
        expectViolation("not.noneset2","not-noneset(end)",null,"falsehood.noneset2","true");
        expectViolation("not.anyset","not-anyset",null,"falsehood.anyset","ack");
    }

    public void testFailIfInlineAndNestedConditions()
    {
        runExpecting("testFailInlineAndNested","Cannot have inline and nested conditions");
    }

    public void testFailIfIncompleteInlineEquals()
    {
        runExpecting("testIncompleteInlineEqualsCaught","Inline 'equals' must have two args");
    }

    public void testFailMixingInlineConditions()
    {
        runExpecting("testFailMixingInlineConditions","Inline 'equals' and 'isref' is boo-boo");
    }

    public void testUsingMsgId()
    {
        expectBuildExceptionContaining("fail.with.msgid","Wanted-To","Teensy Weensy Spider");
    }

    public void testCompoundTruthsInAttributeLogicAND()
    {
        runTargetNoOutput("compound.truths.and");
    }

    public void testCompoundTruthsInAttributeLogicOR()
    {
        runTargetNoOutput("compound.truths.or");
    }

    public void testCompoundTruthsInNestedLogicAND()
    {
        runTargetNoOutput("compound.truths.nested.logic.and");
        assertPropertyEquals("truth.nested.logic",null);
    }

    public void testCompoundFalsehoodsLogicInAttributeAND() throws Exception
    {
        expectViolation("compound.falsehoods.and","'Fail-here' not numeric",null,"falsehood.and","true");
        String ordering = getProject().getProperty("expected.condition.ordering");
        assertNotNil(ordering,"Expected condition ordering documented");
        String realLog= getLog();
        println("LOG:",realLog);
        assertTrue(realLog.indexOf(ordering)>=0,"Ordering is "+ordering);
    }
    public void testCompoundFalsehoodsLogicInAttributeOR() throws Exception
    {
        expectViolation("compound.falsehoods.or","None were true",null,"falsehood.or","true");
        String ordering = getProject().getProperty("expected.condition.ordering");
        assertNotNil(ordering,"Expected condition ordering documented");
        String realLog= getLog();
        println("LOG:",realLog);
        assertTrue(realLog.indexOf(ordering)>=0,"Ordering is "+ordering);
    }

    public void testEiffelisqueAliasesTrue()
    {
        runTargetNoOutput("eiffel.like.truths");
    }

    public void testGoodReferrals()
    {
        runTargetNoOutput("testReferrals");
        assertPropertyEquals("broken.referral0",null);
    }

    public void testCircularReferrals()
    {
        String log= runExpecting("testCircularReferrals","CircularReferral");
        assertTrue(log.indexOf("rule chain contains a circular dependency")>-1,"Circular problem found");
    }

    public void testIncompatibleReferrals()
    {
        String log= runExpecting("testIncompatibleReferrals","IncompatibleReferral");
        assertTrue(log.indexOf("must be compatible with effect")>-1,"Incompatibility found");
    }

    public void testMatchesCondition()
    {
        runTargetNoOutput("testMatches");
    }

    public void testIsNumericCondition()
    {
        runTarget("testIsNumeric");
    }

    public void testOutOfOrderParameters_AntX04()
    {
        runTarget("testOutOfOrderParameters_AntX04");
    }

    public void testCustomConditions_AntX04()
    {
        runTarget("testCustomConditions_AntX04");
    }

    public void testWhitespaceItems_AntX04()
    {
        runTarget("testWhitespaceItems_AntX04");
    }

    public void testMalformedSingleChecks_AntX04()
    {
        runTarget("testMalformedSingleChecks_AntX04");
    }

    public void testMalformedGroupChecks_AntX04()
    {
        runTarget("testMalformedGroupChecks_AntX04");
    }

    public void testMalformedAnySetChecks_AntX04()
    {
        runTarget("testMalformedAnySetChecks_AntX04");
    }

    public void testAntVersionChecks_AntX04()
    {
        runTarget("testAntVersionChecks_AntX04");
    }

    public void testGroupedPropertySets_AntX04()
    {
        runTarget("testGroupedPropertySets_AntX04");
    }

    public void testAntXAssertionHasJUnitAssertion_AntX04()
    {
        BuildAssertionException aX = new BuildAssertionException("I died");
        Throwable juthr = aX.getJUnitLink();
        assertNotNil(juthr,"JUnit-linked assertion error");
        println("JUNIT ERROR: ",juthr);
    }

    public void testLimitedUnknownMessageDisplay_AntX05()
    {
        expectBuildExceptionContaining("testLimitedUnknownMessageDisplay_AntX05",
            "Wanted-To","False.Is.Not.True...Shocking");
    }
    
    public void testCanShorthandClientConditions_AntX05()
    {
        runTarget("testCanShorthandClientConditions_AntX05");
    }

    public void testFailUnknownShorthandClientCondition_AntX05()
    {
        runExpecting("testFailUnknownShorthandClientCondition_AntX05",
            "The 'Xisset' condition should be unrecognized");
    }
}


/* end-of-AssertionRuleTest.java */
