/**
 * $Id: InformationSaver.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.parameters;

/**
 * A component that can write some kind of captured information to the file system. The
 * item must support (at least) the standard
 * '<span class="src">tofile=path</span>' and
 * '<span class="src">append=[yes|no]</span>' short-hand parameters. Whether the
 * parameter should specify a file, directory, or both is implementation specific.
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  n/a
 * @.group   api,helper
 **/

public interface InformationSaver
{
    /**
     * Sets the file path for this item's captured output.
     * Whether the path represents a full path or a project-relative
     * path is up to this interface's implementation.
     * @param outputFile the output file's path (non-null)
     **/
    void setToFile(String outputFile);


    /**
     * Returns this item's target file path for output. Can return
     * <i>null</i> if never set. Whether this is an absolute or
     * relative path is implementation defined.
     **/
    String getToFilePath();



    /**
     * Marks whether this item should try to append its new
     * information to its output stream.
     * @param append <i>true</i> if should try to append
     **/
    void setAppend(boolean append);


    /**
     * Returns <i>true</i> if this item will try to append
     * any new information to an existing output sink.
     **/
    boolean willTryAppend();
}

/* end-of-InformationSaver.java */
