/**
 * $Id: Strings.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.helpers;

/**
 * Collection of common string constants.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,helper
 **/

public final class Strings
{
    /**
     * System-specific line separator.
     **/
    public static final String NL= System.getProperty("line.separator","\n");

    /**
     * Length of the system-specific {@linkplain #NL line separator}.
     **/
    public static final int NL_LEN= NL.length();


    /**
     * The string "<i>true</i>".
     **/
    public static final String TRUE= String.valueOf(true);

    /**
     * The string "<i>false</i>".
     **/
    public static final String FALSE= String.valueOf(false);

    /**
     * The string "<i>null</i>".
     **/
    public static final String NULL= "null";

    /**
     * The string "<i>default</i>".
     **/
    public static final String DEFAULT= "default";

    /**
     * The string "<i>defaults</i>".
     * @since JWare/AntX 0.5
     **/
    public static final String DEFAULTS= "defaults";

    /**
     * The string "<i>inherit</i>".
     **/
    public static final String INHERIT= "inherit";

    /**
     * The string "<i>enclosing</i>".
     * @since JWare/AntX 0.3
     **/
    public static final String ENCLOSING= "enclosing";

    /**
     * The string "<i>all</i>".
     **/
    public static final String ALL= "all";

    /**
     * The string "<i>user</i>".
     **/
    public static final String USER= "user";

    /**
     * The string "<i>none</i>".
     **/
    public static final String NONE= "none";

    /**
     * The string "<i>current</i>".
     * @since JWare/AntX 0.4
     **/
    public static final String CURRENT= "current";

    /**
     * The string "<i>context</i>".
     * @since JWare/AntX 0.4
     **/
    public static final String CONTEXT= "context";

    /**
     * The string "<i>install</i>".
     **/
    public static final String INSTALL= "install";

    /**
     * The string "<i>uninstall</i>".
     **/
    public static final String UNINSTALL= "uninstall";

    /**
     * The string "<i>undefined</i>".
     * @since JWare/AntX 0.5
     **/
    public static final String UNDEFINED= "undefined";

    /**
     * The string "<i>now</i>".
     * @since JWare/AntX 0.5
     **/
    public static final String NOW= "now";

    /** Prevent this. **/
    private Strings()
    {
    }
}

/* end-of-Strings.java */
