/**
 * $Id: IffAnt.java 187 2007-03-25 17:59:16Z ssmc $
 * Copyright 2004-2005,2007 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://antxtras.sf.net/          EMAIL- jware[at]users[dot]sourceforge[dot]net
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.go;

import  org.apache.tools.ant.Main;
import  org.apache.tools.ant.Project;
import  org.apache.tools.ant.util.regexp.RegexpMatcher;
import  org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

import  com.idaremedia.antx.helpers.Tk;

/**
 * Implementation of the general <i>if-ant</i> test for all conditional components.
 * The <span class="src">IffAnt</span> criteria passes if the current Ant runtime's
 * version string matches the given regular expression.
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2004-2005,2007 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5.1
 * @.safety  multiple
 * @.group   impl,helper
 * @.pattern GoF.Strategy
 * @see      Go
 * @see      IffOs
 * @see      com.idaremedia.antx.parameters.PlatformConditional PlatformConditional
 **/

public final class IffAnt
{
    private static final RegexpMatcherFactory REMFactory =
        new RegexpMatcherFactory();

    private static final String DFLT_VERSION_PROPERTY =
        "ant.version";

    /**
     * Returns <i>true</i> if the version information stored in
     * the given property matches the version regular expression.
     * @param pattern version pattern (non-null)
     * @param property the name of the property storing version info
     * @param P project from which properties read
     * @param ifNot <i>true</i> if test should be for no-match
     **/
    public static boolean pass(String pattern, String property,
                               Project P, boolean ifNot)
    {
        if (Tk.isWhitespace(pattern) || Tk.isWhitespace(property)) {
            return false;
        }
        pattern = Tk.resolveString(P,pattern);

        RegexpMatcher re = REMFactory.newRegexpMatcher(P);
        re.setPattern(pattern);

        String setting = null;
        if (P!=null) {
            setting = P.getProperty(property);
        }
        if (setting==null) {//NB:can happen in test|in-early-load environments!
            setting = Main.getAntVersion();
        }

        boolean is = re.matches(setting);
        re= null;
        return ifNot ? !is : is;
    }


    /**
     * Returns <i>true</i> if the current Ant runtime's version
     * information matches the version regular expression.
     * @param pattern version pattern (non-null)
     * @param P project from which properties read
     * @param ifNot <i>true</i> if test should be for no-match
     **/
    public static boolean pass(String pattern, Project P, boolean ifNot)
    {
        return pass(pattern, DFLT_VERSION_PROPERTY, P, ifNot);
    }


    /**
     * Execute test for an "if-antLike" conditional parameter.
     * @since    JWare/AntX 0.4
     * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
     * @version  0.5
     * @.safety  single
     * @.group   impl,helper
     **/
    public static final class IsLike extends Go.TestSkeleton {
        public IsLike() {
        }
        public IsLike(String pattern) {
            super(pattern);
        }
        public boolean pass(Project P) {
            verifyInited();
            return IffAnt.pass(getParameter(),P,false);
        }
        public String getParameterName() {
            return "ifAntLike";
        }
    }


    /**
     * Execute test for an "unless-antLike" conditional parameter.
     * @since    JWare/AntX 0.4
     * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
     * @version  0.5
     * @.safety  single
     * @.group   impl,helper
     **/
    public static final class IsNotLike extends Go.TestSkeleton {
        public IsNotLike() {
        }
        public IsNotLike(String pattern) {
            super(pattern);
        }
        public boolean pass(Project P) {
            verifyInited();
            return IffAnt.pass(getParameter(),P,true);
        }
        public String getParameterName() {
            return "unlessAntLike";
        }
    }


    /**
     * Execute test for an "if-antLike-property" conditional parameter.
     * @since    JWare/AntX 0.4
     * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
     * @version  0.5
     * @.safety  single
     * @.group   impl,helper
     **/
    public static final class IsLikeProperty extends Go.TestSkeleton {
        public IsLikeProperty() {
        }
        public IsLikeProperty(String pattern, String property) {
            super(pattern);
            setSourceProperty(property);
        }
        public boolean pass(Project P) {
            verifyInited();
            return IffAnt.pass(getParameter(),m_versionProperty,P,false);
        }
        public String getParameterName() {
            return "ifAntLikeProperty";
        }
        public void setSourceProperty(String property)
        {
            m_versionProperty = property;
        }
        private String m_versionProperty= DFLT_VERSION_PROPERTY;
    }


    /**
     * Prevent; only helpers public.
     **/
    private IffAnt() {
    }
}

/* end-of-IffAnt.java */
