/**
 * $Id: ExecutionBubble.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.wrap;

import  com.idaremedia.antx.FixtureOverlay;
import  com.idaremedia.antx.apis.ProjectDependent;
import  com.idaremedia.antx.apis.Requester;

/**
 * Task execution helper that tries to restore a task's surrounding Ant
 * <span class="src">Project</span> build-iteration context to the state it reflected
 * just before task executed.
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  n/a
 * @.group   impl,infra
 **/

public interface ExecutionBubble extends ProjectDependent, FixtureOverlay
{
    /**
     * Captures project state for later restoration. Must be
     * matched with a call to {@linkplain #leave leave}.
     * @param block the client to be executed (non-null)
     **/
    boolean enter(Requester block);



    /**
     * Restores project state as best can to state before task
     * executed. Will affect project properties and references mostly.
     * Should be done <em>once</em> for each call to
     * {@linkplain #enter enter}.
     * @param block the client that was executed (non-null)
     **/
    boolean leave(Requester block);
}

/* end-of-ExecutionBubble.java */
