/**
 * $Id: AlwaysTask.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.wrap;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.starters.StrictInnerTaskSet;

/**
 * Set of tasks to be <em>always</em> executed within a protected taskset. These tasks
 * are run whether or not an error is detected. AlwaysTasks can only be nested inside
 * of protected tasksets.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,infra
 * @see      ProtectedTaskSet
 **/

public class AlwaysTask extends StrictInnerTaskSet
{
    /**
     * Initializes a new AlwayTask instance.
     **/
    public AlwaysTask()
    {
        super(AntX.flow+"protect");
    }


    /**
     * Initializes a new subclassed AlwayTask instance.
     * @param iam CV-label (non-null)
     * @param delayConfigure <i>true</i> if nested items will
     *         be configured explicitly by application
     **/
    public AlwaysTask(String iam, boolean delayConfigure)
    {
        super(iam,delayConfigure);
    }
}

/* end-of-AlwaysTask.java */
