/**
 * $Id: StepLauncherInstallTask.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.call;

import  java.util.Map;

import  org.apache.tools.ant.Project;
import  org.apache.tools.ant.Target;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.AssertableLibDefinition;
import  com.idaremedia.antx.FixtureInitializer;
import  com.idaremedia.antx.flowcontrol.FlowConstants;

/**
 * Convenience task that dynamically installs the AntX {@linkplain StepLauncher step
 * launcher} target.
 * <p>
 * <b>Example Usage:</b><pre>
 *    &lt;project name="&#8230;" ...&gt;
 *        &lt;<b>install-steprunner</b>/&gt;
 *        &#8230;
 *    &lt;/project&gt;
 * </pre>
 *
 * @since     JWare/AntX 0.4
 * @author    ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    api,helper
 * @see       StepLauncher
 **/

public final class StepLauncherInstallTask extends AssertableLibDefinition
    implements FixtureInitializer
{
    /**
     * Initializes new installer task.
     **/
    public StepLauncherInstallTask()
    {
        super(AntX.flow+"steplauncher");
    }



    /**
     * Installs the special AntX step launcher target is it
     * doesn't already exist.
     * @throws BuildException if unable to add target for any reason.
     **/
    public void execute()
    {
        verifyCanExecute_("execute");

        Project P = getProject();
        Map all = P.getTargets();
        Target t = (Target)all.get(FlowConstants.DEFAULT_STEP_CALLER_SPECIAL_TARGETNAME);

        if (t==null) {
            t = new Target();
            t.setProject(P);
            t.setName(FlowConstants.DEFAULT_STEP_CALLER_SPECIAL_TARGETNAME);

            StepLauncher runr = new StepLauncher();
            runr.setProject(P);
            runr.setTaskName("runsteps");
            runr.setTaskType("runsteps");
            runr.setLocation(getLocation());
            runr.setOwningTarget(t);
            runr.init();

            t.addTask(runr);
            P.addOrReplaceTarget(t);
        }
    }
}

/* end-of-StepLauncherInstallTask.java */
