/**
 * $Id: FlowConstants.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol;

import  com.idaremedia.antx.AntX;

/**
 * Various properties used by AntX to implement its nested step and call functionality.
 * These constants are declared publicly to allow AntX extension tools to manage these
 * special properties (and their targets).
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   multiple
 * @.group    impl,helper
 **/

public final class FlowConstants 
{
    //-- Used internally by AntX+friends (nooo user-script touchy)

    /** Property that contains target name of the special step-launch task. **/
    public final static String DEFAULT_STEP_CALLER_SPECIAL_TARGETNAME_PROP    =
        AntX.ANTX_INTERNAL_ID+"stepcaller.targetname";

    /** Property for the originating step-calling target. **/
    public final static String DEFAULT_STEP_LAUNCHER_TARGET_PROP  =
        AntX.ANTX_INTERNAL_ID+"steplaunch.targetname";

    /** Optional property for the required class of called steps. **/
    public final static String DEFAULT_STEP_LAUNCHER_STEPCLASS_PROP  =
        AntX.ANTX_INTERNAL_ID+"steplaunch.stepclass";

    /** Property for the requested step's name in the calling target. **/
    public final static String DEFAULT_STEP_LAUNCHER_STEPNAME_PROP =
        AntX.ANTX_INTERNAL_ID+"steplaunch.stepname";

    /** Property for the maximum search depth for named inlined steps. **/
    public final static String DEFAULT_STEP_LAUNCHER_SEARCHDEPTH_PROP =
        AntX.ANTX_INTERNAL_ID+"steplaunch.searchdepth";


    /** The default name of the AntX special "step-launch" target. **/
    public final static String DEFAULT_STEP_CALLER_SPECIAL_TARGETNAME=
        "--"+AntX.ANTX_CONFIG_ID+".runsteps";


    private FlowConstants()
    {
        //prevent
    }
}

/* end-of-FlowConstants.java */