/**
 * $Id: OtherEmitConfiguration.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.feedback.tests;

import  com.idaremedia.apis.DiagnosticsEmitter;

import  com.idaremedia.antx.NoiseLevel;
import  com.idaremedia.antx.feedback.DefaultEmitConfiguration;
import  com.idaremedia.antx.feedback.EmitConfiguration;
import  com.idaremedia.antx.feedback.LJDiagnosticsEmitter;

/**
 * Fake configuration that differs from DefaultEmitConfiguration. Used to verify that
 * EmitContexts work.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,test,helper
 **/

public final class OtherEmitConfiguration implements EmitConfiguration
{
    /**
     * Initialize new default configuration. (Anyone can create a default
     * instance although the singleton is all that's needed for most uses.)
     **/
    public OtherEmitConfiguration()
    {
        m_rootEmitter = LJDiagnosticsEmitter.FACTORY.newEmitter("Mock.JWare.AntX.EmitConfiguration");
    }


    /**
     * Returns a wrapper for a fixed Log4j logger.
     **/
    public DiagnosticsEmitter getEmitter()
    {
        return m_rootEmitter;
    }


    /**
     * Returns a wrapper for the Log4j logger of specified
     * grouping. Delegates to the default configuration.
     **/
    public DiagnosticsEmitter getCustomEmitter(String grpId)
    {
        return DefaultEmitConfiguration.INSTANCE.getCustomEmitter(grpId);
    }


    /**
     * Returns the default runtime noiselevel.
     **/
    public NoiseLevel getNoiseLevel()
    {
        return NoiseLevel.ERROR;
    }


    /**
     * Returns the default grouping (empty string).
     **/
    public String getFrom()
    {
        return "";
    }


    /**
     * Updates incoming buffer with list of special properties values
     * to be recorded. No-op.
     **/
    public boolean getPropertiesNameList(StringBuffer list)
    {
        list.append("ant.version");
        return true;
    }


    /**
     * Returns <i>true</i> to automatically include timestamps always.
     **/
    public boolean wantTimestamp()
    {
        return true;
    }


    /**
     * Returns a simple MEDIUM formatted date-time string.
     * Delegates to the default configuration.
     * @param ms the timestamp (milliseconds)
     **/
    public String stampify(long ms)
    {
        return DefaultEmitConfiguration.INSTANCE.stampify(ms);
    }


    /**
     * Returns <i>false</i> so emitted messages are not passed
     * to Ant's standard logging system.
     **/
    public boolean shouldEcho()
    {
        m_shouldEchoCalls++;
        return false;
    }
    public int getShouldEchoCalls()
    {
        return m_shouldEchoCalls;
    }


    /**
     * Returns a single dot.
     **/
    public String getGroupingPathSeparator()
    {
        return ".";
    }


    private final DiagnosticsEmitter m_rootEmitter;
    private int m_shouldEchoCalls=0;
}

/* end-of-OtherEmitConfiguration.java */
