/**
 * $Id: ErrorSnapshotRenderer.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.feedback;

import  java.io.ByteArrayOutputStream;
import  java.io.IOException;

import  org.apache.log4j.or.ObjectRenderer;

import  com.idaremedia.apis.UIStringManager;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.ErrorSnapshot;
import  com.idaremedia.antx.helpers.Tk;
import com.idaremedia.antx.print.DisplayRequest;
import  com.idaremedia.antx.print.ErrorPrinter;

/**
 * Object Renderer adapter for AntX {@linkplain ErrorSnapshot ErrorSnapshots}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,helper
 * @see      ErrorSnapshot
 * @see      EmitTask
 **/

public class ErrorSnapshotRenderer implements ObjectRenderer
{
    /**
     * Creates new error snapshot object renderer.
     **/
    public ErrorSnapshotRenderer()
    {
        m_printWorker = new ErrorPrinter();
    }


    /**
     * Returns the standard <i>AntX</i> resource bundle strings
     * manager. Never returns <i>null</i>.
     **/
    protected final UIStringManager uistrs()
    {
        return AntX.uistrs();
    }


    /**
     * Returns a standard string description of given error snapshot.
     * The returned string is formatted like that returned by the
     * AntX {@linkplain ErrorPrinter ErrorPrinter} display helper.
     * @param es error snapshot (non-null)
     * @return formatted string (non-null)
     **/
    protected final String defaultStringFrom(ErrorSnapshot es)
    {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
            DisplayRequest dr = new DisplayRequest(es);
            m_printWorker.print(dr,bos);
            String s = bos.toString();
            bos.close();
            bos = null;
            return s;
        } catch(IOException ioX) {
            return es.toString();
        }
    }


    /**
     * Returns a standard string description of error snapshot. Subclasses
     * should override this method to produce XML, HTML or whatever.
     **/
    protected String stringFrom(ErrorSnapshot es)
    {
        return defaultStringFrom(es);
    }


    /**
     * If incoming object is an ErrorSnapshot, returns a standard formatted
     * string of its contents. Otherwise, defers to the object's 'toString'
     * method.
     **/
    public String doRender(Object object)
    {
        if (object instanceof ErrorSnapshot) {
            return stringFrom((ErrorSnapshot)object);
        }
        return Tk.stringFrom(object,null);
    }

    private final ErrorPrinter m_printWorker;
}

/* end-of-ErrorSnapshotRenderer.java */
