/**
 * $Id: RulesTk.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.condition.solo;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Project;
import  org.apache.tools.ant.TaskAdapter;
import  org.apache.tools.ant.taskdefs.condition.Condition;

import  com.idaremedia.antx.Iteration;
import  com.idaremedia.antx.apis.Requester;
import  com.idaremedia.antx.helpers.Strings;

/**
 * Collection of rule evaluation related utility methods.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   multiple
 * @.group    impl,helper
 **/

public final class RulesTk
{
    private RulesTk()
    {
        //only utility methods from us!
    }


    /**
     * Returns <i>true</i> if the named condition evaluates true.
     * Uses the standard condition value URI handler to do the
     * heavy lifting.
     * @param clnt caller (non-null)
     * @param testId reference of condition to evaluate (non-null)
     * @return <i>true</i> if evaluated true.
     * @since JWare/AntX 0.5
     **/
    public static boolean evalTest(String testId, Requester clnt)
    {
        ConditionValueURIHandler runner = new ConditionValueURIHandler();
        String result = runner.valueFrom(testId,"$test:"+testId, clnt);
        return Strings.TRUE.equals(result);
    }



    /**
     * Check that the given reference points to a condition-like
     * object.
     * @param refid the referenced object (non-null)
     * @param clnt error handler (non-null)
     * @throws IllegalArgumentException if either parameter is <i>null</i>.
     * @throws BuildException if the referred-to thing does not
     *      exist or is of an incompatible class.
     * @since JWare/AntX 0.5
     **/
    public static void verifyTest(String refid, Requester clnt)
    {
        if (refid==null || clnt==null) {
            throw new IllegalArgumentException();
        }
        String error = null;
        Object ref = clnt.getProject().getReference(refid);
        if (ref==null) {
            error = Iteration.uistrs().get("task.missing.refid",refid);
        } else {
            if (ref instanceof TaskAdapter) {
                ref = ((TaskAdapter)ref).getProxy();
            }
            if (!(ref instanceof Condition) && !(ref instanceof ShareableCondition)) {
                error = Iteration.uistrs().get("task.bad.refid",refid,
                    Condition.class.getName(), ref.getClass().getName());
            }
        }

        if (error!=null) {
            clnt.problem(error, Project.MSG_ERR);
            throw new BuildException(error, clnt.getLocation());
        }
    }
}

/* end-of-RulesTk.java */