/**
 * $Id: ExternalPropertyDef.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.condition;

import  java.util.Map;

import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.FlexString;

/**
 * Special flex value that has a predetermined <em>target</em> value. All of this
 * items modifiers (like trimming) are still applied to target string.
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,helper
 **/

public final class ExternalPropertyDef extends FlexString
{
    /**
     * Initializes a new undefined predef value. This item's
     * target string must be specified before it is used.
     **/
    public ExternalPropertyDef()
    {
        super();
        setIsProperty(true);
    }


    /**
     * Initializes a new attached but undefined predef value.
     * This item's target string must be specified before it
     * is used.
     * @param P enclosing project (non-null)
     **/
    public ExternalPropertyDef(Project P)
    {
        this();
        require_(P!=null,"ctor- nonzro proj");
        setProject(P);
    }


    /**
     * Defines both this item's source and target strings.
     * @param definition the source (key) and target (value)
     **/
    public void set(Map.Entry definition)
    {
        require_(definition!=null,"set- nonzro defn");
        set(definition.getKey().toString());
        setTargetString(definition.getValue().toString());
    }


    /**
     * Defines this item's target string.
     * @param value the target value
     **/
    public void setTargetString(String value)
    {
        m_predefValue = value;
    }


    /**
     * Returns the predefined source string. The source is
     * not resolved in anyway.
     **/
    public String sourceString(Project P)
    {
        return get();
    }


    /**
     * Returns the predefined value string. The source is not
     * used to retrieve any information from the fixture.
     **/
    public String targetString(Project P, String source)
    {
        return m_predefValue;
    }


    private String m_predefValue;
}

/* end-of-ExternalPropertyDef.java */
