/**
 * $Id: LogsRecorder.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003,2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.capture;

import  com.idaremedia.antx.NoiseLevel;

/**
 * Any iteration-based helper that captures Ant logged messages or System stream
 * messages.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2003,2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  n/a
 * @.group   impl,helper
 **/

public interface LogsRecorder
{
    /**
     * Returns <i>true</i> if this recorder would consider the given
     * noise level important.
     * @param nl noise level (non-null)
     **/
    boolean isImportant(NoiseLevel nl);


    /**
     * Returns a <em>copy</em> of this recorder's current important
     * logs. The returned messages are determined by what this
     * recorder considers important.
     * @see #isImportant
     **/
    String copyOfImportantLogs();


    /**
     * Returns a <em>copy</em> of all logs captured by this recorder
     * so far. The returned string contains all levels of messages
     * from debug to fatal since recorder was started or last reset.
     * @see #copyOfImportantLogs
     **/
    String copyOfAllLogs();


    /**
     * Clears this recorder's logs as if no log event ever
     * recorded.
     **/
    void clearLogs();
}

/* end-of-LogsRecorder.java */
