/**
 * $Id: Tk.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.apis;

import  org.apache.tools.ant.Project;

/**
 * Utilities used by implementation classes in this package. We are at the top of
 * the interface food chain so we cannot depend on the standard AntX helpers package
 * or any other.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   multiple
 * @.group    impl,helper
 **/

final class Tk
{
    /**
     * Returns the leaf of a class's name. If the leaf partion of the
     * class name includes the '$' character (as for inner or anonymous
     * classes), all occurances of  '$' are replaced by a '-'
     * character.
     * @param cls the class (non-null)
     **/
    static String leafNameFrom(Class cls)
    {
        if (cls==null) {
            throw new IllegalArgumentException("leafFrom- NULL class");
        }
        String cn = cls.getName();
        int i= cn.lastIndexOf('.');
        if (i != -1) {
            return cn.substring(i+1).replace('$','-');
        }
        return cn;
    }



    /**
     * Returns a generic system identity string for given object.
     * @param thing the thing to be stringified (can be <i>null</i>)
     * @since JWare/AntX 0.4
     **/
    static String identityStringFrom(Object thing)
    {
        if (thing==null) {
            return "null";
        }
        return thing.getClass().getName()
            +"@"
            +System.identityHashCode(thing);
    }



    /**
     * Tries to obtain the result of an object's
     * <span class="src">toString()</span> handling. If the object's
     * handling generates an exception (often the case in Ant 1.6+)
     * this method returns a generic system identity string.
     * @param thing the thing to be stringified (can be <i>null</i>)
     * @param P [optional] project for problem logging purposes
     * @since JWare/AntX 0.4
     **/
    static String stringFrom(Object thing, Project P)
    {
        try {
            return String.valueOf(thing);
        } catch(RuntimeException rtX) {
            if (P!=null) {
                P.log(rtX.getMessage(),Project.MSG_INFO);
            }
            return identityStringFrom(thing);
        }
    }

    private Tk()
    {
    }
}

/* end-of-Tk.java */