/**
 * $Id: BuildInfo.java,in 187 2007-03-25 17:59:16Z ssmc $
 * Copyright 2003,2007 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://antxtras.sf.net/          EMAIL- jware[at]users[dot]sourceforge[dot]net
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx;

import  java.io.Serializable;

import  com.idaremedia.apis.Buildstrs;

/**
 * Build information that describes this release of the JWare/AntX product.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2003,2007 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5.1
 * @.safety  multiple
 * @.group   impl,infra
 **/

public final class BuildInfo implements Buildstrs, Serializable, Cloneable
{
    /**
     * Initializes a new BuildInfo instance based on
     * runtime generated values.
     **/
    public BuildInfo()
    {
    }


    /**
     * Returns diagnostics id for build; always "<code>AntX</code>".
     **/
    public final String getID()
    {
        return "AntX";
    }


    /**
     * Returns displayable for build, for example
     * "<code>iDare Media's JWare/AntX source</code>".
     **/
    public final String getDisplayName()
    {
        return "iDare Media's AntXtras/Foundation, v0.5.1_build33, Mar-25-2007";
    }


    /**
     * Returns product version for this build, for example
     * "<code>1&#46;0b3</code>."
     **/
    public final String getVersion()
    {
        return "0.5.1";
    }


    /**
     * Returns this build's (unique) identifer, for example
     * "<code>1&#46;0b3_build123</code>."
     **/
    public final String getBuildVersion()
    {
        return "0.5.1_build33";
    }


    /**
     * Returns the product shorthand namespace prefix, for example
     * "<code>jware&#46;</code>".
     **/
    public final String getNSPrefix()
    {
        return "jw.antx";
    }


    /**
     * Returns the product namespace URI, for example
     * "<code>http://www&#46;jware&#46;info/jwf-xmlschema</code>".
     **/
    public final String getNSURI()
    {
        return "http://antxtras.sf.net/";
    }


    /**
     * Returns the product properties namespace prefix, for example
     * "<code>PET</code>" as used in
     * "<code>PET&#46;repository&#46;filesystem&#46;root</code>."
     **/
    public final String getPropertiesPrefix()
    {
        return "jware.antx.";
    }


    /**
     * Returns date of build in an abbreviated format, for example
     * "<code>Jan012001,12:34GMT</code>".
     **/
    public final String getAbbrDate()
    {
        return "Mar-25-2007";
    }


    /**
     * Returns date of build in a verbose format, for example
     * "<code>Monday 1 January 2001, 12:34:34 GMT</code>".
     **/
    public final String getLongDate()
    {
        return "Mar252007_232831GMT";
    }


    /**
     * Returns OS on which build generated, for example
     * "<code>RedHat Linux 6&#46;1 (patch03)</code>".
     **/
    public final String getOS()
    {
        return "Windows XP 5.1";
    }


    /**
     * Returns build builder's (system) identifier, for example
     * "<code>buildmaster</code>".
     **/
    public final String getBuilderID()
    {
        return "ssmc";
    }


    /**
     * Returns build builder's common name, for example
     * "<code>Robert Jenson</code>".
     **/
    public final String getBuilderCN()
    {
        return "buildmeister";
    }


    /**
     * Returns host information for machine used for build, for example
     * "<code>buildbox1</code>".
     **/
    public final String getHostID()
    {
        return "milo";
    }


    /**
     * Returns various paths used to generate build (class,libs,etc.);
     * optional.
     **/
    public final String getUsedPaths()
    {
        return "Undeclared";
    }


    /**
     * Determines if this buildstrs is equal to given object&#150; which has
     * to be another BuildInfo instance.
     **/
    public boolean equals(Object o)
    {
        if (o==null) {
            return false;
        }
        if (o==this || o.getClass()==com.idaremedia.antx.BuildInfo.class) {
            return true;
        }
        return false;
    }


    /**
     * Returns a hash value for this object. Since all instances of this
     * class are considered equal, the hash value depends on the class's id.
     **/
    public int hashCode()
    {
        return HASH_;
    }


    /**
     * Returns clone of this object.
     **/
    public Object clone()
    {
        try {
            return super.clone();
        } catch(CloneNotSupportedException clnx) {
            throw new InternalError("Clone broken");
        }
    }


    /**
     * Returns a VM-shareable singleton reference.
     * @.safety guarded
     **/
    public static synchronized Buildstrs getInstance()
    {
        if (sm_Instance==null) {
            sm_Instance= new com.idaremedia.antx.BuildInfo();
        }
        return sm_Instance;
    }


    private static final int HASH_= BuildInfo.class.getName().hashCode();
    private static Buildstrs sm_Instance=null;
}

/* end-of-BuildInfo.java */
