/**
 * $Id: AssertableProjectComponent.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx;

import  org.apache.tools.ant.Project;
import  org.apache.tools.ant.ProjectComponent;

import  com.idaremedia.apis.UIStringManager;

import  com.idaremedia.antx.apis.ProjectDependent;
import  com.idaremedia.antx.helpers.Tk;

/**
 * Extension of basic Ant <i>ProjectComponent</i> that adds builtin assertions.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,infra
 **/

public abstract class AssertableProjectComponent extends ProjectComponent
    implements ProjectDependent
{
    /**
     * Creates new unlabeled component.
     **/
    protected AssertableProjectComponent()
    {
        super();
        Iam_="";
    }


    /**
     * Creates new cv-labeled component.
     * @param iam CV-label (non-null)
     **/
    protected AssertableProjectComponent(String iam)
    {
        super();
        Iam_= Tk.cvlabelFrom(iam);
    }


    /**
     * Returns this component's CV-label. Never <i>null</i>.
     **/
    protected final String cvlabel_()
    {
        return Iam_;
    }


    /**
     * Shortcut that returns this task's internal AntX UI
     * strings manager. Never returns <i>null</i>.
     * @see AntX#uistrs
     **/
    public final UIStringManager uistrs()
    {
        return AntX.uistrs();
    }


    /**
     * Throws assertion error if pre-condtion is not met.
     * @param c pre-condition
     * @param msg [optional] failure message (if not met)
     * @throws IllegalArgumentException if condition not met
     **/
    protected final void require_(boolean c, String msg)
    {
        if (!c) {
            String ermsg = uistrs().get("cv.require",Iam_,msg);
            log(ermsg, Project.MSG_ERR);
            throw new IllegalArgumentException(ermsg);
        }
    }


    /**
     * Throws assertion error if post-condition is not met. Used
     * for post-condition verification.
     * @param c post-condition
     * @param msg [optional] failure message (if not met)
     * @throws IllegalStateException if condition not met
     **/
    protected final void ensure_(boolean c, String msg)
    {
        if (!c) {
            String ermsg = uistrs().get("cv.ensure",Iam_,msg);
            log(ermsg, Project.MSG_ERR);
            throw new IllegalStateException(ermsg);
        }
    }


    /**
     * Throws assertion error if condition is not met. Used for
     * block and invariant verification.
     * @param c condition
     * @param msg [optional] failure message (if not met)
     * @throws IllegalStateException if condition not met
     **/
    protected final void verify_(boolean c, String msg)
    {
        if (!c) {
            String ermsg = uistrs().get("cv.verify",Iam_,msg);
            log(ermsg, Project.MSG_ERR);
            throw new IllegalStateException(ermsg);
        }
    }


    /**
     * Notes an unexpected but manageable problem has occured.
     * Just logs a warning by default.
     * @param t [optional] causing throwable
     * @param msg caller's additional (context) message
     **/
    protected final void unexpected_(Throwable t, String msg)
    {
        String ermsg = uistrs().get("cv.unexpected",Iam_,msg,t);
        log(ermsg, Project.MSG_WARN);
    }


    /**
     * Verifies we're in a live project (created from build
     * process).
     **/
    protected final void verifyInProject_(String calr)
    {
        if (getProject()==null) {
            String ermsg = uistrs().get("cv.verifyInP",Iam_,calr);
            log(ermsg, Project.MSG_ERR);
            throw new IllegalStateException(ermsg);
        }
    }


    private final String Iam_;
}

/* end-of-AssertableProjectComponent.java */
