/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.BerliozOption;
import org.pageseeder.berlioz.GlobalSettings;
import org.pageseeder.berlioz.config.ConfigException;
import org.pageseeder.berlioz.config.RelocationConfig;
import org.pageseeder.berlioz.servlet.BerliozConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelocationFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelocationFilter.class);
    private String controlKey = "";
    private @Nullable File mappingFile;
    private transient @Nullable RelocationConfig config = null;

    public void init(FilterConfig config) {
        ServletContext context = config.getServletContext();
        File contextPath = new File(context.getRealPath("/"));
        File webinfPath = new File(contextPath, "WEB-INF");
        String mapping = config.getInitParameter("config");
        this.controlKey = GlobalSettings.get(BerliozOption.XML_CONTROL_KEY);
        if (mapping == null) {
            LOGGER.warn("Missing 'config' init-parameter - filter will have no effect");
            return;
        }
        File mappingFile = new File(webinfPath, mapping);
        if (!mappingFile.exists()) {
            LOGGER.warn("'config' init-parameter points to non existing file {} - filter will have no effect", (Object)mappingFile.getAbsolutePath());
        }
        this.mappingFile = mappingFile;
    }

    public void destroy() {
        this.mappingFile = null;
        this.config = null;
        this.controlKey = "";
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            this.doHTTPFilter((HttpServletRequest)req, (HttpServletResponse)res, chain);
        }
    }

    public void doHTTPFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws ServletException, IOException {
        String from;
        RelocationConfig mapping;
        String to;
        if ("true".equals(req.getParameter("berlioz-reload")) && BerliozConfig.hasControl(req, this.controlKey)) {
            this.config = null;
        }
        if ((to = (mapping = this.config()).relocate(from = req.getRequestURI())) != null) {
            to = this.ensureSafeTarget(to.replaceAll("[\\n\\r]*", ""));
            LOGGER.debug("Relocating from {} to {}", (Object)from, (Object)to);
            RequestDispatcher dispatcher = req.getRequestDispatcher(to);
            if (dispatcher != null) {
                res.setHeader("Content-Location", to);
                dispatcher.forward((ServletRequest)req, (ServletResponse)res);
            } else {
                LOGGER.debug("Invalid URL, no dispatcher found");
            }
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private RelocationConfig config() {
        RelocationConfig config = this.config;
        if (config == null) {
            try {
                config = RelocationConfig.newInstance(this.mappingFile);
                LOGGER.info("Loaded relocation configuration: {} rules found", (Object)config.size());
            }
            catch (ConfigException ex) {
                LOGGER.warn("Unable to load configuration: {}", (Object)ex.getMessage());
                config = new RelocationConfig();
            }
            this.config = config;
        }
        return config;
    }

    private String ensureSafeTarget(String to) {
        return Paths.get(to.replaceAll("[\\n\\r]*", ""), new String[0]).normalize().toString();
    }
}

