/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.content.Environment;
import org.pageseeder.berlioz.content.Location;
import org.pageseeder.berlioz.furi.URIResolveResult;
import org.pageseeder.berlioz.servlet.CoreHttpRequest;
import org.pageseeder.berlioz.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpRequestWrapper
implements ContentRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestWrapper.class);
    private final HttpServletRequest _req;
    private final HttpServletResponse _res;
    private final Environment _env;
    private final Location _loc;
    private final Map<String, String> _parameters;

    HttpRequestWrapper(CoreHttpRequest core, Map<String, String> parameters) {
        Objects.requireNonNull(core, "Cannot construct wrapper around null request.");
        this._req = core.request();
        this._res = core.response();
        this._env = core.environment();
        this._loc = core.location();
        this._parameters = parameters;
    }

    @Override
    public final String getBerliozPath() {
        return this._loc.info().path();
    }

    @Override
    public final @Nullable String getParameter(String name) {
        @Nullable String value = this._parameters.get(name);
        if (value == null) {
            value = this._req.getParameter(name);
        }
        return "".equals(value) ? null : value;
    }

    @Override
    public final String getParameter(String name, String def) {
        String value = this.getParameter(name);
        return value == null || "".equals(value) ? def : value;
    }

    @Override
    public final String @Nullable [] getParameterValues(String name) {
        @Nullable String value = this._parameters.get(name);
        if (value != null) {
            return new String[]{value};
        }
        return this._req.getParameterValues(name);
    }

    @Override
    public final Enumeration<String> getParameterNames() {
        return Collections.enumeration(this._parameters.keySet());
    }

    @Override
    public final Environment getEnvironment() {
        return this._env;
    }

    @Override
    public final int getIntParameter(String name, int def) {
        String value = this.getParameter(name);
        if (value == null || "".equals(value)) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Unable to parse value " + value + " for " + name + " parameter.", (Throwable)ex);
            return def;
        }
    }

    @Override
    public final long getLongParameter(String name, long def) {
        String value = this.getParameter(name);
        if (value == null || "".equals(value)) {
            return def;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Unable to parse value " + value + " for " + name + " parameter.", (Throwable)ex);
            return def;
        }
    }

    @Override
    public final @Nullable Date getDateParameter(String name) {
        String value = this.getParameter(name);
        if (value == null) {
            return null;
        }
        try {
            return ISO8601.parseAuto(value);
        }
        catch (ParseException ex) {
            LOGGER.warn("The date parameter cannot be parsed :" + this._req.getParameter(name), (Throwable)ex);
            return null;
        }
    }

    public final @Nullable String getPathInfo() {
        return this._req.getPathInfo();
    }

    @Override
    public final Cookie @Nullable [] getCookies() {
        return this._req.getCookies();
    }

    @Override
    public final @Nullable Object getAttribute(String name) {
        return this._req.getAttribute(name);
    }

    @Override
    public final void setAttribute(String name, Object o) {
        this._req.setAttribute(name, o);
    }

    public final HttpServletRequest getHttpRequest() {
        return this._req;
    }

    public final HttpServletResponse getHttpResponse() {
        return this._res;
    }

    @Override
    public final Location getLocation() {
        return this._loc;
    }

    public final boolean isMultipartContent() {
        if (!"post".equals(this._req.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = this._req.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    @Override
    public final @Nullable HttpSession getSession() {
        return this._req.getSession();
    }

    public static String getBerliozPath(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null) {
            return pathInfo;
        }
        String path = req.getServletPath();
        int dot = path.lastIndexOf(46);
        return dot != -1 ? path.substring(0, dot) : path;
    }

    protected static Map<String, String> toParameters(HttpServletRequest req, URIResolveResult results) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map map = req.getParameterMap();
        for (Map.Entry entry : map.entrySet()) {
            parameters.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        for (String name : results.names()) {
            Object o = results.get(name);
            if (o == null) continue;
            parameters.put(name, o.toString());
        }
        return parameters;
    }
}

