/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.pageseeder.berlioz.json.JsonWriteFailureException;
import org.pageseeder.berlioz.json.JsonWriter;

final class JacksonJsonWriter
implements JsonWriter {
    private static JsonFactory factory;
    private final JsonGenerator _json;

    private JacksonJsonWriter(JsonGenerator json) {
        this._json = json;
    }

    @Override
    public JsonWriter startArray(String name) {
        try {
            this._json.writeFieldName(name);
            this._json.writeStartArray();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter startArray() {
        try {
            this._json.writeStartArray();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter endArray() {
        try {
            this._json.writeEndArray();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter startObject(String name) {
        try {
            this._json.writeFieldName(name);
            this._json.writeStartObject();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter startObject() {
        try {
            this._json.writeStartObject();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter endObject() {
        try {
            this._json.writeEndObject();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter name(String name) {
        try {
            this._json.writeFieldName(name);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter nullValue(String name) {
        try {
            this._json.writeNullField(name);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter nullValue() {
        try {
            this._json.writeNull();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter value(double number) {
        try {
            this._json.writeNumber(number);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter value(long number) {
        try {
            this._json.writeNumber(number);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter value(String value) {
        try {
            this._json.writeString(value);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter value(boolean number) {
        try {
            this._json.writeBoolean(number);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter field(String name, String value) {
        try {
            this._json.writeStringField(name, value);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter field(String name, boolean value) {
        try {
            this._json.writeBooleanField(name, value);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter field(String name, double value) {
        try {
            this._json.writeNumberField(name, value);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter field(String name, long value) {
        try {
            this._json.writeNumberField(name, value);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public boolean inObject() {
        return this._json.getOutputContext().inObject();
    }

    @Override
    public void close() {
        try {
            this._json.close();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
    }

    @Override
    public void flush() {
        try {
            this._json.flush();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
    }

    public static JacksonJsonWriter newInstance(OutputStream out) {
        try {
            JsonGenerator json = factory.createGenerator(out);
            return new JacksonJsonWriter(json);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
    }

    public static JacksonJsonWriter newInstance(Writer writer) {
        try {
            JsonGenerator json = factory.createGenerator(writer);
            return new JacksonJsonWriter(json);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
    }

    static {
        try {
            factory = new JsonFactory();
        }
        catch (NoClassDefFoundError error) {
            System.err.println("To use the JacksonJsonWriter ensure that Jackson is only your classpath!");
            throw error;
        }
    }
}

