/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.http;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.regex.Pattern;

public final class PerformanceServerTiming {
    private static final Pattern VALID_TOKEN = Pattern.compile("^[!#$%&'*+\\-.^_`|~0-9a-zA-Z]+$");
    private final String _name;
    private final String _description;
    private final double _duration;
    private static final Pattern NON_VCHAR = Pattern.compile("[^\\u0009\\u0020!-~]");

    public PerformanceServerTiming(String name, double duration) {
        this(name, "", duration);
    }

    public PerformanceServerTiming(String name, String description, double duration) {
        this._name = this.checkName(name);
        this._description = this.ensureValidDescription(description);
        this._duration = duration;
    }

    public String name() {
        return this._name;
    }

    public String description() {
        return this._description;
    }

    public double duration() {
        return this._duration;
    }

    public String toHeaderString() {
        StringBuilder header = new StringBuilder(this._name);
        if (this._description.length() > 0) {
            if (VALID_TOKEN.matcher(this._description).matches()) {
                header.append(";desc=").append(this._description);
            } else {
                header.append(";desc=\"").append(this._description.replaceAll("([\"\\\\])", "\\\\$1")).append('\"');
            }
        }
        if (this._duration >= 0.0) {
            DecimalFormat format = new DecimalFormat("#.###");
            format.setRoundingMode(RoundingMode.CEILING);
            header.append(";dur=").append(format.format(this._duration));
        }
        return header.toString();
    }

    private String checkName(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name must be at least 1 character long");
        }
        if (!VALID_TOKEN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid name used for server timing");
        }
        return name;
    }

    private String ensureValidDescription(String description) {
        if (description == null || description.length() == 0) {
            return "";
        }
        return NON_VCHAR.matcher(description).replaceAll("_");
    }
}

