/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.furi;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.furi.VariableResolver;
import org.pageseeder.berlioz.furi.VariableType;

public class VariableBinder {
    private static final VariableResolver DEFAULT_RESOLVER = new VariableResolver(){

        @Override
        public boolean exists(String value) {
            return true;
        }

        @Override
        public @NonNull String resolve(String value) {
            return value;
        }
    };
    private final Map<String, VariableResolver> _byname = new Hashtable<String, VariableResolver>();
    private final Map<String, VariableResolver> _bytype = new Hashtable<String, VariableResolver>();

    @Deprecated
    public void bind(String name, VariableResolver resolver) {
        this._byname.put(name, resolver);
    }

    public void bindName(String name, VariableResolver resolver) {
        this._byname.put(name, resolver);
    }

    public void bindType(String type, VariableResolver resolver) {
        this._bytype.put(type, resolver);
    }

    public VariableResolver getResolver(String name, @Nullable VariableType type) {
        VariableResolver resolver = this._byname.get(name);
        if (resolver == null && type != null) {
            resolver = this._bytype.get(type.getName());
        }
        return resolver != null ? resolver : DEFAULT_RESOLVER;
    }

    public VariableResolver getResolver(String name) {
        VariableResolver resolver = this._byname.get(name);
        return resolver != null ? resolver : DEFAULT_RESOLVER;
    }

    public VariableResolver getResolver(@Nullable VariableType type) {
        if (type == null) {
            return DEFAULT_RESOLVER;
        }
        VariableResolver resolver = this._bytype.get(type.getName());
        return resolver != null ? resolver : DEFAULT_RESOLVER;
    }

    public boolean isNameBound(@Nullable String name) {
        if (name == null) {
            return false;
        }
        return this._byname.containsKey(name);
    }

    public boolean isTypeBound(@Nullable String type) {
        if (type == null) {
            return false;
        }
        return this._bytype.containsKey(type);
    }
}

