/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.furi;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.furi.Expandable;
import org.pageseeder.berlioz.furi.Parameters;
import org.pageseeder.berlioz.furi.Token;
import org.pageseeder.berlioz.furi.TokenFactory;
import org.pageseeder.berlioz.furi.TokenLiteral;
import org.pageseeder.berlioz.furi.URITemplateSyntaxException;

public class URITemplate
implements Expandable {
    private static final Pattern EXPANSION_PATTERN = Pattern.compile("\\{[^}]*}");
    private final String _template;
    private final List<Token> _tokens;

    URITemplate(URITemplate original) {
        this._template = original._template;
        this._tokens = original._tokens;
    }

    public URITemplate(String template) {
        this._template = Objects.requireNonNull(template, "Cannot create a URI template with a null template");
        this._tokens = URITemplate.digest(template);
    }

    public URITemplate(String template, TokenFactory factory) {
        this._template = Objects.requireNonNull(template, "Cannot create a URI template with a null template");
        this._tokens = URITemplate.digest(template, factory != null ? factory : TokenFactory.getInstance());
    }

    @Override
    public final String expand(Parameters parameters) {
        StringBuilder uri = new StringBuilder();
        for (Token t : this._tokens) {
            uri.append(t.expand(parameters));
        }
        return uri.toString();
    }

    public static String expand(String template, Parameters parameters) {
        return new URITemplate(template).expand(parameters);
    }

    public static List<Token> digest(String template) throws URITemplateSyntaxException {
        return URITemplate.digest(template, TokenFactory.getInstance());
    }

    public static List<Token> digest(String template, TokenFactory factory) throws URITemplateSyntaxException {
        String text;
        ArrayList<Token> tokens = new ArrayList<Token>();
        Matcher m = EXPANSION_PATTERN.matcher(template);
        int start = 0;
        while (m.find()) {
            String exp;
            Token t;
            if (m.start() > start) {
                text = template.substring(start, m.start());
                tokens.add(new TokenLiteral(text));
            }
            if ((t = factory.newToken(exp = m.group())) != TokenLiteral.EMPTY) {
                tokens.add(t);
            }
            start = m.end();
        }
        if (start < template.length()) {
            text = template.substring(start);
            if (text.endsWith("*")) {
                tokens.add(new TokenLiteral(text.substring(0, text.length() - 1)));
                tokens.add(factory.newToken("*"));
            } else {
                tokens.add(new TokenLiteral(text));
            }
        }
        return tokens;
    }

    protected final List<Token> tokens() {
        return this._tokens;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        URITemplate t = (URITemplate)o;
        return Objects.equals(this._template, t._template);
    }

    public int hashCode() {
        return 127 * this._template.hashCode() + this._template.hashCode();
    }

    public String toString() {
        return this._template;
    }
}

