/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.furi;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.furi.Matchable;
import org.pageseeder.berlioz.furi.Token;
import org.pageseeder.berlioz.furi.URITemplateSyntaxException;
import org.pageseeder.berlioz.furi.Variable;

abstract class TokenBase
implements Token {
    private final String _exp;

    public TokenBase(String exp) {
        this._exp = Objects.requireNonNull(exp, "Cannot create a token with a null value.");
    }

    @Override
    public boolean isResolvable() {
        return this instanceof Matchable;
    }

    @Override
    public String expression() {
        return this._exp;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TokenBase t = (TokenBase)o;
        return Objects.equals(this._exp, t._exp);
    }

    public int hashCode() {
        return 31 * this._exp.hashCode() + this._exp.hashCode();
    }

    public String toString() {
        return this._exp;
    }

    protected static String strip(String exp) {
        if (exp.length() < 2) {
            return exp;
        }
        if (exp.charAt(0) == '{' && exp.charAt(exp.length() - 1) == '}') {
            return exp.substring(1, exp.length() - 1);
        }
        return exp;
    }

    protected static List<Variable> toVariables(String exp) throws URITemplateSyntaxException {
        String[] exps = exp.split(",");
        ArrayList<Variable> vars = new ArrayList<Variable>(exps.length);
        for (String e : exps) {
            if (e == null) continue;
            vars.add(Variable.parse(e));
        }
        return vars;
    }
}

